import { SKU } from "./types";
/**
 * Forcing an initial fetch for this URL preps the server cache and speeds up the checkout
 * process a little (as we can do this while we load initial user data during checkout).
 *
 * This makes sense only when the real navigation will be in another context (e.g. the
 * system browser, when running in Electron). Otherwise prefetchCheckout does the same
 * thing server-side but helpfully also caches in the browser too.
 */
export declare function prepareCheckout(email: string, sku: SKU, source: 'web' | 'app'): void;
/**
 * Prefetch the checkout, using a prefetch link in the HEAD. This should be used before
 * loading the checkout in the same context. If loading it elsewhere (the system browser)
 * then prepareCheckout should be used instead.
 */
export declare function prefetchCheckout(email: string, sku: SKU, source: 'web' | 'app'): void;
export declare function goToCheckout(email: string, sku: SKU, source: 'web' | 'app'): Promise<void>;
export declare function openNewCheckoutWindow(email: string, sku: SKU, source: 'web' | 'app'): void;
