import { initSentry, catchErrors, StatusError } from '../../errors.ts';
initSentry();

import { getCorsResponseHeaders } from '../../cors.ts';
import { refreshToken } from '../../user-data-facade.ts';

export const handler = catchErrors(async (event) => {
    let headers = getCorsResponseHeaders(event);

    if (event.httpMethod === 'OPTIONS') {
        return { statusCode: 200, headers, body: '' };
    } else if (event.httpMethod !== 'POST') {
        return { statusCode: 405, headers, body: '' };
    }

    let token;
    try {
        ({ refreshToken: token } = JSON.parse(event.body!));
    } catch (e) {
        throw new StatusError(400, 'Invalid request body');
    }

    if (!token) throw new StatusError(400, 'Refresh token is required');

    const result = await refreshToken(token, event.requestContext.identity.sourceIp);

    return {
        statusCode: 200,
        headers: { ...headers,
            'content-type': 'application/json'
        },
        body: JSON.stringify(result)
    };
});