"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getByteLength = getByteLength;
exports.isInteger = isInteger;
exports.getIncompleteClass = getIncompleteClass;
exports.getClass = getClass;
exports.__PHP_Incomplete_Class = void 0;

class __PHP_Incomplete_Class {
  constructor(name) {
    this.__PHP_Incomplete_Class_Name = name;
  }

}

exports.__PHP_Incomplete_Class = __PHP_Incomplete_Class;

function getByteLength(contents, options) {
  if (typeof Buffer !== 'undefined') {
    return Buffer.byteLength(contents, options.encoding);
  }

  return encodeURIComponent(contents).replace(/%[A-F\d]{2}/g, 'U').length;
}

function isInteger(value) {
  return typeof value === 'number' && parseInt(value, 10) === value;
}

function getIncompleteClass(name) {
  return new __PHP_Incomplete_Class(name);
}

function getClass(prototype) {
  function PhpClass() {}

  PhpClass.prototype = prototype;
  return PhpClass;
}