export declare type Omit<T, K> = Pick<T, Exclude<keyof T, K>>;
export declare type RequireProps<T, K extends keyof T> = Omit<T, K> & Required<Pick<T, K>>;
export declare type MaybePromise<T> = T | Promise<T>;
declare type SubsetKeyOf<T, Ks extends keyof T = keyof T> = Ks;
export declare type Replace<T, KV extends {
    [K in SubsetKeyOf<T, any>]: unknown;
}> = Omit<T, keyof KV> & {
    [K in keyof KV]: KV[K];
};
export declare type Mutable<T> = {
    -readonly [K in keyof T]: T[K];
};
export {};
//# sourceMappingURL=type-utils.d.ts.map