/// <reference types="node" />
export declare type CAOptions = (CertDataOptions | CertPathOptions);
export interface CertDataOptions extends BaseCAOptions {
    key: string;
    cert: string;
}
export interface CertPathOptions extends BaseCAOptions {
    keyPath: string;
    certPath: string;
}
export interface BaseCAOptions {
    /**
     * Minimum key length when generating certificates. Defaults to 2048.
     */
    keyLength?: number;
    /**
     * The countryName that will be used in the certificate for incoming TLS
     * connections.
     */
    countryName?: string;
    /**
     * The localityName that will be used in the certificate for incoming TLS
     * connections.
     */
    localityName?: string;
    /**
     * The organizationName that will be used in the certificate for incoming TLS
     * connections.
     */
    organizationName?: string;
}
export declare type PEM = string | string[] | Buffer | Buffer[];
export declare type GeneratedCertificate = {
    key: string;
    cert: string;
    ca: string;
};
/**
 * Generate a CA certificate for mocking HTTPS.
 *
 * Returns a promise, for an object with key and cert properties,
 * containing the generated private key and certificate in PEM format.
 *
 * These can be saved to disk, and their paths passed
 * as HTTPS options to a Mockttp server.
 */
export declare function generateCACertificate(options?: {
    commonName?: string;
    organizationName?: string;
    countryName?: string;
    bits?: number;
}): Promise<{
    key: string;
    cert: string;
}>;
export declare function generateSPKIFingerprint(certPem: PEM): string;
export declare function getCA(options: CAOptions): Promise<CA>;
export declare class CA {
    private caCert;
    private caKey;
    private options;
    private certCache;
    constructor(options: CertDataOptions);
    generateCertificate(domain: string): GeneratedCertificate;
}
//# sourceMappingURL=tls.d.ts.map