/// <reference types="node" />
import * as net from 'net';
import * as tls from 'tls';
import * as http2 from 'http2';
import { OngoingRequest, TlsConnectionEvent } from '../types';
export declare function isLocalPortActive(interfaceIp: '::1' | '127.0.0.1', port: number): Promise<unknown>;
export declare const isLocalIPv6Available: boolean;
export declare const isLocalhostAddress: (host: string | null | undefined) => boolean | RegExpMatchArray | null;
export declare const isSocketLoop: (outgoingSockets: net.Socket[] | Set<net.Socket>, incomingSocket: net.Socket) => boolean;
export declare function getParentSocket(socket: net.Socket): any;
export declare const requireSocketResetSupport: () => void;
/**
 * Reset the socket where possible, or at least destroy it where that's not possible.
 *
 * This has a few cases for different layers of socket & tunneling, designed to
 * simulate a real connection reset as closely as possible. That means, in general,
 * we unwrap the connection as far as possible whilst still only affecting a single
 * request.
 *
 * In practice, we unwrap HTTP/1 & TLS back as far as we can, until we hit either an
 * HTTP/2 stream or a raw TCP connection. We then either send a RST_FRAME or a TCP RST
 * to kill that connection.
 */
export declare function resetOrDestroy(requestOrSocket: net.Socket | OngoingRequest & {
    socket?: net.Socket;
} | http2.Http2ServerRequest): void;
export declare function buildSocketEventData(socket: net.Socket & Partial<tls.TLSSocket>): TlsConnectionEvent;
export declare function buildSocketTimingInfo(): Required<net.Socket>['__timingInfo'];
//# sourceMappingURL=socket-util.d.ts.map