/// <reference types="node" />
import * as net from 'net';
import * as http from 'http';
import * as http2 from 'http2';
import { Headers, OngoingRequest, CompletedRequest, OngoingResponse, CompletedResponse, CompletedBody, TimingEvents, InitiatedRequest, RawHeaders } from "../types";
export declare const isAbsoluteUrl: (url: string) => boolean;
export declare const isRelativeUrl: (url: string) => boolean;
export declare const isAbsoluteProtocollessUrl: (url: string) => boolean;
export declare const getUrlWithoutProtocol: (url: string) => string;
export declare const getPathFromAbsoluteUrl: (url: string) => string;
export declare const getEffectivePort: (url: {
    protocol: string | null;
    port: string | null;
}) => number;
export declare const shouldKeepAlive: (req: OngoingRequest) => boolean;
export declare const writeHead: (response: http.ServerResponse | http2.Http2ServerResponse, status: number, statusMessage?: string | undefined, headers?: Headers | RawHeaders | undefined) => void;
export declare function isHttp2(message: http.IncomingMessage | http.ServerResponse | http2.Http2ServerRequest | http2.Http2ServerResponse | OngoingRequest | OngoingResponse): message is http2.Http2ServerRequest | http2.Http2ServerResponse;
export declare function encodeBodyBuffer(buffer: Uint8Array, headers: Headers): Promise<Uint8Array | Buffer>;
export declare function decodeBodyBuffer(buffer: Buffer, headers: Headers): Promise<Buffer>;
export declare const isMockttpBody: (body: any) => body is CompletedBody;
export declare const buildBodyReader: (body: Buffer, headers: Headers) => CompletedBody;
export declare const parseRequestBody: (req: http.IncomingMessage | http2.Http2ServerRequest, options: {
    maxSize: number;
}) => void;
/**
 * Build an initiated request: the external representation of a request
 * that's just started.
 */
export declare function buildInitiatedRequest(request: OngoingRequest): InitiatedRequest;
/**
 * Build a completed request: the external representation of a request
 * that's been completely received (but not necessarily replied to).
 */
export declare function waitForCompletedRequest(request: OngoingRequest): Promise<CompletedRequest>;
export declare function trackResponse(response: http.ServerResponse, timingEvents: TimingEvents, tags: string[], options: {
    maxSize: number;
}): OngoingResponse;
/**
 * Build a completed response: the external representation of a response
 * that's been completely written out and sent back to the client.
 */
export declare function waitForCompletedResponse(response: OngoingResponse | CompletedResponse): Promise<CompletedResponse>;
export declare function tryToParseHttpRequest(input: Buffer, socket: net.Socket): PartiallyParsedHttpRequest;
declare type PartiallyParsedHttpRequest = {
    protocol?: string;
    httpVersion?: string;
    method?: string;
    url?: string;
    headers?: Headers;
    rawHeaders?: RawHeaders;
    hostname?: string;
    path?: string;
};
export declare function parseRawHttpResponse(input: Buffer, request: OngoingRequest): CompletedResponse;
export {};
//# sourceMappingURL=request-utils.d.ts.map