"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDeferred = exports.objectAllPromise = exports.filter = void 0;
const _ = require("lodash");
async function filter(array, test) {
    let testResults = await Promise.all(array.map(test));
    return array.filter((v, i) => testResults[i]);
}
exports.filter = filter;
async function objectAllPromise(obj) {
    return _.zipObject(Object.keys(obj), await Promise.all(Object.values(obj)));
}
exports.objectAllPromise = objectAllPromise;
function getDeferred() {
    let resolveCallback;
    let rejectCallback;
    let result = new Promise((resolve, reject) => {
        resolveCallback = resolve;
        rejectCallback = reject;
    });
    result.resolve = resolveCallback;
    result.reject = rejectCallback;
    return result;
}
exports.getDeferred = getDeferred;
//# sourceMappingURL=promise.js.map