import { Headers, OngoingResponse, RawHeaders } from "../types";
export declare const findRawHeader: (rawHeaders: RawHeaders, targetKey: string) => [key: string, value: string] | undefined;
export declare const findRawHeaderIndex: (rawHeaders: RawHeaders, targetKey: string) => number;
export declare const findRawHeaders: (rawHeaders: RawHeaders, targetKey: string) => [key: string, value: string][];
/**
 * Return node's _very_ raw headers ([k, v, k, v, ...]) into our slightly more convenient
 * pairwise tuples [[k, v], [k, v], ...] RawHeaders structure.
 */
export declare function pairFlatRawHeaders(flatRawHeaders: string[]): RawHeaders;
export declare function flattenPairedRawHeaders(rawHeaders: RawHeaders): string[];
/**
 * Take a raw headers, and turn them into headers, but without some of Node's concessions
 * to ease of use, i.e. keeping multiple values as arrays.
 *
 * This lowercases all names along the way, to provide a convenient header API for most
 * downstream use cases, and to match Node's own behaviour.
 */
export declare function rawHeadersToObject(rawHeaders: RawHeaders): Headers;
/**
 * Take raw headers, and turn them into headers just like `rawHeadersToObject` but
 * also preserves case en route.
 *
 * This is separated because our public APIs should _not_ do this, but there's a few
 * internal use cases where we want to, notably including passing headers to WS which
 * only accepts a headers object when sending upstream requests, but does preserve
 * case from the object.
 */
export declare function rawHeadersToObjectPreservingCase(rawHeaders: RawHeaders): Headers;
export declare function objectHeadersToRaw(headers: Headers): RawHeaders;
export declare function objectHeadersToFlat(headers: Headers): string[];
export declare function h2HeadersToH1(h2Headers: RawHeaders): RawHeaders;
export declare function h1HeadersToH2(headers: RawHeaders): RawHeaders;
export declare function dropDefaultHeaders(response: OngoingResponse): void;
export declare function validateHeader(name: string, value: string | string[]): boolean;
//# sourceMappingURL=header-utils.d.ts.map