/// <reference types="node" />
import { EventEmitter } from 'events';
import * as stream from 'stream';
export declare const asBuffer: (input: Buffer | Uint8Array | string) => Buffer;
export declare type BufferInProgress = Promise<Buffer> & {
    currentChunks: Buffer[];
    failedWith?: Error;
    events: EventEmitter;
};
export declare const bufferThenStream: (buffer: BufferInProgress, inputStream: stream.Readable) => stream.Readable;
export declare const bufferToStream: (buffer: Buffer) => stream.Readable;
export declare const streamToBuffer: (input: stream.Readable, maxSize?: any) => BufferInProgress;
export declare function splitBuffer(input: Buffer, splitter: string, maxParts?: number): Buffer[];
//# sourceMappingURL=buffer-utils.d.ts.map