/// <reference types="node" />
import { Duplex } from 'stream';
import { MaybePromise } from '../util/type-utils';
import { RuleParameterReference, RuleParameters } from '../rules/rule-parameters';
import type { ProxySetting, ProxySettingSource, ProxyConfig } from '../rules/proxy-config';
export declare function serialize<T extends Serializable>(obj: T, stream: Duplex): SerializedValue<T>;
export declare function deserialize<T extends SerializedValue<Serializable>, C extends {
    new (...args: any): any;
    deserialize(data: SerializedValue<any>, channel: ClientServerChannel, ruleParams: RuleParameters): any;
}>(data: T, stream: Duplex, ruleParams: RuleParameters, lookup: {
    [key: string]: C;
}): InstanceType<C>;
export declare type SerializedValue<T> = T & {
    topicId: string;
};
export declare type Serialized<T> = {
    [K in keyof T]: T[K] extends string | undefined ? string | undefined : T[K] extends Array<unknown> ? Array<SerializedValue<T[K][0]>> : SerializedValue<T[K]>;
};
export declare abstract class Serializable {
    abstract type: string;
    /**
     * @internal
     */
    serialize(_channel: ClientServerChannel): unknown;
    /**
     * @internal
     */
    static deserialize(data: SerializedValue<any>, _channel: ClientServerChannel, _ruleParams: RuleParameters): any;
    dispose(): void;
}
interface Message {
    topicId?: string;
}
export declare class ClientServerChannel extends Duplex {
    private rawStream;
    readonly topicId: string;
    constructor(rawStream: Duplex, topicId?: string);
    private _onRawStreamError;
    private _onRawStreamFinish;
    /**
     * @internal @hidden
     */
    _write(message: Message, encoding: BufferEncoding, callback: (error?: Error | null) => void): void;
    _readFromRawStream: (rawData: any) => void;
    private reading;
    _read(): void;
    request<T extends {}, R>(data: T): Promise<R>;
    request<T extends {}, R>(action: string, data: T): Promise<R>;
    onRequest<T, R>(cb: (request: T) => MaybePromise<R>): void;
    onRequest<T, R>(actionName: string, cb: (request: T) => MaybePromise<R>): void;
    dispose(disposeReceived?: boolean): void;
}
export declare function serializeBuffer(buffer: Buffer): string;
export declare function deserializeBuffer(buffer: string): Buffer;
declare const SERIALIZED_PARAM_REFERENCE = "__mockttp__param__reference__";
export declare type SerializedRuleParameterReference<R> = {
    [SERIALIZED_PARAM_REFERENCE]: string;
};
export declare function maybeSerializeParam<T, R>(value: T | RuleParameterReference<R>): T | SerializedRuleParameterReference<R>;
export declare function ensureParamsDeferenced<T>(value: T | SerializedRuleParameterReference<T>, ruleParams: RuleParameters): T;
export declare type SerializedProxyConfig = ProxySetting | string | undefined | SerializedRuleParameterReference<ProxySettingSource> | Array<SerializedProxyConfig>;
export declare function serializeProxyConfig(proxyConfig: ProxyConfig, channel: ClientServerChannel): SerializedProxyConfig;
export declare function deserializeProxyConfig(proxyConfig: SerializedProxyConfig, channel: ClientServerChannel, ruleParams: RuleParameters): ProxySettingSource;
export {};
//# sourceMappingURL=serialization.d.ts.map