/// <reference types="node" />
import * as net from 'net';
import { OngoingRequest, CompletedRequest, Explainable } from "../../types";
import { MaybePromise } from '../../util/type-utils';
import * as matchers from "../matchers";
import * as completionCheckers from "../completion-checkers";
import { WebSocketHandler } from "./websocket-handlers";
import type { WebSocketHandlerDefinition } from "./websocket-handler-definitions";
export interface WebSocketRule extends Explainable {
    id: string;
    requests: Promise<CompletedRequest>[];
    matches(request: OngoingRequest): MaybePromise<boolean>;
    handle(request: OngoingRequest, response: net.Socket, head: Buffer, record: boolean): Promise<void>;
    isComplete(): boolean | null;
}
export interface WebSocketRuleData {
    id?: string;
    priority?: number;
    matchers: matchers.RequestMatcher[];
    handler: WebSocketHandler | WebSocketHandlerDefinition;
    completionChecker?: completionCheckers.RuleCompletionChecker;
}
export declare class WebSocketRule implements WebSocketRule {
    private matchers;
    private handler;
    private completionChecker?;
    id: string;
    readonly priority: number;
    requests: Promise<CompletedRequest>[];
    requestCount: number;
    constructor(data: WebSocketRuleData);
    explain(withoutExactCompletion?: boolean): string;
    dispose(): void;
}
//# sourceMappingURL=websocket-rule.d.ts.map