/// <reference types="node" />
import { ClientServerChannel, Serializable, SerializedProxyConfig } from "../../serialization/serialization";
import { Explainable, Headers } from "../../types";
import { ProxyConfig } from '../proxy-config';
import { PassThroughHandlerConnectionOptions, ForwardingOptions, PassThroughLookupOptions } from '../passthrough-handling-definitions';
import { CloseConnectionHandlerDefinition, ResetConnectionHandlerDefinition, TimeoutHandlerDefinition } from '../requests/request-handler-definitions';
export interface WebSocketHandlerDefinition extends Explainable, Serializable {
    type: keyof typeof WsHandlerDefinitionLookup;
}
export declare type PassThroughWebSocketHandlerOptions = PassThroughHandlerConnectionOptions;
/**
 * @internal
 */
export interface SerializedPassThroughWebSocketData {
    type: 'ws-passthrough';
    forwarding?: ForwardingOptions;
    lookupOptions?: PassThroughLookupOptions;
    proxyConfig?: SerializedProxyConfig;
    ignoreHostCertificateErrors?: string[] | boolean;
    extraCACertificates?: Array<{
        cert: string;
    } | {
        certPath: string;
    }>;
    clientCertificateHostMap?: {
        [host: string]: {
            pfx: string;
            passphrase?: string;
        };
    };
}
export declare class PassThroughWebSocketHandlerDefinition extends Serializable implements WebSocketHandlerDefinition {
    readonly type = "ws-passthrough";
    readonly lookupOptions: PassThroughLookupOptions | undefined;
    readonly proxyConfig?: ProxyConfig;
    readonly forwarding?: ForwardingOptions;
    readonly ignoreHostHttpsErrors: string[] | boolean;
    readonly clientCertificateHostMap: {
        [host: string]: {
            pfx: Buffer;
            passphrase?: string;
        };
    };
    readonly extraCACertificates: Array<{
        cert: string | Buffer;
    } | {
        certPath: string;
    }>;
    constructor(options?: PassThroughWebSocketHandlerOptions);
    explain(): string;
    /**
     * @internal
     */
    serialize(channel: ClientServerChannel): SerializedPassThroughWebSocketData;
}
export declare class EchoWebSocketHandlerDefinition extends Serializable implements WebSocketHandlerDefinition {
    readonly type = "ws-echo";
    explain(): string;
}
export declare class ListenWebSocketHandlerDefinition extends Serializable implements WebSocketHandlerDefinition {
    readonly type = "ws-listen";
    explain(): string;
}
export declare class RejectWebSocketHandlerDefinition extends Serializable implements WebSocketHandlerDefinition {
    readonly statusCode: number;
    readonly statusMessage: string;
    readonly headers: Headers;
    readonly body: Buffer | string;
    readonly type = "ws-reject";
    constructor(statusCode: number, statusMessage?: string, headers?: Headers, body?: Buffer | string);
    explain(): string;
}
export { CloseConnectionHandlerDefinition, ResetConnectionHandlerDefinition, TimeoutHandlerDefinition };
export declare const WsHandlerDefinitionLookup: {
    'ws-passthrough': typeof PassThroughWebSocketHandlerDefinition;
    'ws-echo': typeof EchoWebSocketHandlerDefinition;
    'ws-listen': typeof ListenWebSocketHandlerDefinition;
    'ws-reject': typeof RejectWebSocketHandlerDefinition;
    'close-connection': typeof CloseConnectionHandlerDefinition;
    'reset-connection': typeof ResetConnectionHandlerDefinition;
    timeout: typeof TimeoutHandlerDefinition;
};
//# sourceMappingURL=websocket-handler-definitions.d.ts.map