"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assertParamDereferenced = exports.dereferenceParam = exports.isParamReference = exports.MOCKTTP_PARAM_REF = void 0;
exports.MOCKTTP_PARAM_REF = Symbol('MOCKTTP_PARAM_REF');
function isParamReference(input) {
    return input && !!input[exports.MOCKTTP_PARAM_REF];
}
exports.isParamReference = isParamReference;
;
function dereferenceParam(paramRef, params) {
    const paramKey = paramRef[exports.MOCKTTP_PARAM_REF];
    if (paramKey in params) {
        return params[paramKey];
    }
    else {
        throw new Error(`Invalid reference to undefined rule parameter '${paramKey}'`);
    }
}
exports.dereferenceParam = dereferenceParam;
;
function assertParamDereferenced(maybeParamRef) {
    if (isParamReference(maybeParamRef)) {
        const paramKey = maybeParamRef[exports.MOCKTTP_PARAM_REF];
        throw new Error(`Non-dereferenced rule parameter used unexpectedly: ${paramKey}`);
    }
    else {
        return maybeParamRef;
    }
}
exports.assertParamDereferenced = assertParamDereferenced;
//# sourceMappingURL=rule-parameters.js.map