"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deserializeWebSocketRuleData = exports.deserializeRuleData = void 0;
const serialization_1 = require("../serialization/serialization");
const matchers = require("./matchers");
const completionCheckers = require("./completion-checkers");
const request_handlers_1 = require("./requests/request-handlers");
const websocket_handlers_1 = require("./websockets/websocket-handlers");
function deserializeRuleData(data, stream, ruleParameters) {
    return {
        id: data.id,
        priority: data.priority,
        matchers: data.matchers.map((m) => (0, serialization_1.deserialize)(m, stream, ruleParameters, matchers.MatcherLookup)),
        handler: (0, serialization_1.deserialize)(data.handler, stream, ruleParameters, request_handlers_1.HandlerLookup),
        completionChecker: data.completionChecker && (0, serialization_1.deserialize)(data.completionChecker, stream, ruleParameters, completionCheckers.CompletionCheckerLookup)
    };
}
exports.deserializeRuleData = deserializeRuleData;
function deserializeWebSocketRuleData(data, stream, ruleParameters) {
    return {
        id: data.id,
        matchers: data.matchers.map((m) => (0, serialization_1.deserialize)(m, stream, ruleParameters, matchers.MatcherLookup)),
        handler: (0, serialization_1.deserialize)(data.handler, stream, ruleParameters, websocket_handlers_1.WsHandlerLookup),
        completionChecker: data.completionChecker && (0, serialization_1.deserialize)(data.completionChecker, stream, ruleParameters, completionCheckers.CompletionCheckerLookup)
    };
}
exports.deserializeWebSocketRuleData = deserializeWebSocketRuleData;
//# sourceMappingURL=rule-deserialization.js.map