"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.matchesNoProxy = exports.getProxySetting = void 0;
const _ = require("lodash");
async function getProxySetting(configSource, params) {
    if (_.isFunction(configSource))
        return configSource(params);
    else if (_.isArray(configSource)) {
        let result;
        for (let configArrayOption of configSource) {
            result = await getProxySetting(configArrayOption, params);
            if (result)
                break;
        }
        return result;
    }
    else
        return configSource;
}
exports.getProxySetting = getProxySetting;
const matchesNoProxy = (hostname, portNum, noProxyValues) => {
    if (!noProxyValues || noProxyValues.length === 0)
        return false; // Skip everything in the common case.
    const port = portNum.toString();
    const hostParts = hostname.split('.').reverse();
    return noProxyValues.some((noProxy) => {
        const [noProxyHost, noProxyPort] = noProxy.split(':');
        let noProxyParts = noProxyHost.split('.').reverse();
        const lastPart = noProxyParts[noProxyParts.length - 1];
        if (lastPart === '' || lastPart === '*') {
            noProxyParts = noProxyParts.slice(0, -1);
        }
        if (noProxyPort && port !== noProxyPort)
            return false;
        for (let i = 0; i < noProxyParts.length; i++) {
            let noProxyPart = noProxyParts[i];
            let hostPart = hostParts[i];
            if (hostPart === undefined)
                return false; // No-proxy is longer than hostname
            if (noProxyPart !== hostPart)
                return false; // Mismatch
        }
        // If we run out of no-proxy parts with no mismatch then we've matched
        return true;
    });
};
exports.matchesNoProxy = matchesNoProxy;
//# sourceMappingURL=proxy-config.js.map