"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompletionCheckerLookup = exports.NTimes = exports.Thrice = exports.Twice = exports.Once = exports.Always = void 0;
const serialization_1 = require("../serialization/serialization");
class Always extends serialization_1.Serializable {
    constructor() {
        super(...arguments);
        this.type = 'always';
    }
    isComplete() {
        return false;
    }
    explain(seenRequestCount) {
        return explainUntil(seenRequestCount, Infinity, 'always');
    }
}
exports.Always = Always;
class Once extends serialization_1.Serializable {
    constructor() {
        super(...arguments);
        this.type = 'once';
    }
    isComplete(seenRequestCount) {
        return seenRequestCount >= 1;
    }
    explain(seenRequestCount) {
        return explainUntil(seenRequestCount, 1, 'once');
    }
}
exports.Once = Once;
class Twice extends serialization_1.Serializable {
    constructor() {
        super(...arguments);
        this.type = 'twice';
    }
    isComplete(seenRequestCount) {
        return seenRequestCount >= 2;
    }
    explain(seenRequestCount) {
        return explainUntil(seenRequestCount, 2, 'twice');
    }
}
exports.Twice = Twice;
class Thrice extends serialization_1.Serializable {
    constructor() {
        super(...arguments);
        this.type = 'thrice';
    }
    isComplete(seenRequestCount) {
        return seenRequestCount >= 3;
    }
    explain(seenRequestCount) {
        return explainUntil(seenRequestCount, 3, 'thrice');
    }
}
exports.Thrice = Thrice;
class NTimes extends serialization_1.Serializable {
    constructor(count) {
        super();
        this.count = count;
        this.type = 'times';
    }
    isComplete(seenRequestCount) {
        return seenRequestCount >= this.count;
    }
    explain(seenRequestCount) {
        return explainUntil(seenRequestCount, this.count, `${this.count} times`);
    }
}
exports.NTimes = NTimes;
exports.CompletionCheckerLookup = {
    'always': Always,
    'once': Once,
    'twice': Twice,
    'thrice': Thrice,
    'times': NTimes
};
function explainUntil(seen, n, name) {
    if (seen === undefined) {
        // Generic explainer, without the specific count
        return name;
    }
    else {
        return name + " " + (seen < n ? `(seen ${seen})` : "(done)");
    }
}
//# sourceMappingURL=completion-checkers.js.map