import { Serializable } from '../serialization/serialization';
export interface RuleCompletionChecker extends Serializable {
    type: keyof typeof CompletionCheckerLookup;
    isComplete(seenRequestCount: number): boolean;
    explain(seenRequestCount: number | undefined): string;
}
export declare class Always extends Serializable implements RuleCompletionChecker {
    readonly type = "always";
    isComplete(): boolean;
    explain(seenRequestCount: number | undefined): string;
}
export declare class Once extends Serializable implements RuleCompletionChecker {
    readonly type = "once";
    isComplete(seenRequestCount: number): boolean;
    explain(seenRequestCount: number | undefined): string;
}
export declare class Twice extends Serializable implements RuleCompletionChecker {
    readonly type = "twice";
    isComplete(seenRequestCount: number): boolean;
    explain(seenRequestCount: number | undefined): string;
}
export declare class Thrice extends Serializable implements RuleCompletionChecker {
    readonly type = "thrice";
    isComplete(seenRequestCount: number): boolean;
    explain(seenRequestCount: number | undefined): string;
}
export declare class NTimes extends Serializable implements RuleCompletionChecker {
    count: number;
    readonly type = "times";
    constructor(count: number);
    isComplete(seenRequestCount: number): boolean;
    explain(seenRequestCount: number | undefined): string;
}
export declare const CompletionCheckerLookup: {
    always: typeof Always;
    once: typeof Once;
    twice: typeof Twice;
    thrice: typeof Thrice;
    times: typeof NTimes;
};
//# sourceMappingURL=completion-checkers.d.ts.map