"use strict";
/**
 * This file exports the core pluggable admin types, without anything Mockttp-specific
 * included. That's useful so that downstream usage of pluggable without Mockttp doesn't
 * need to load all our dependencies (especially heavy things like brotli-wasm).
 *
 * In future these parts might be extracted into a separate library, but it's a bit tricky
 * to do so immediately as the server side does actually include some unavoidable Mockttp
 * dependencies for API backward compatibility.
 *
 * Everything exported here is experimental, and many change unpredictably in future releases.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Serialization = exports.AdminClient = exports.AdminServer = void 0;
var admin_server_1 = require("../admin/admin-server");
Object.defineProperty(exports, "AdminServer", { enumerable: true, get: function () { return admin_server_1.AdminServer; } });
var admin_client_1 = require("../client/admin-client");
Object.defineProperty(exports, "AdminClient", { enumerable: true, get: function () { return admin_client_1.AdminClient; } });
exports.Serialization = require("../serialization/serialization");
//# sourceMappingURL=pluggable-admin.js.map