"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockttpPluggableAdmin = exports.PluggableAdmin = exports.resetAdminServer = exports.getAdminServer = exports.getRemote = exports.getLocal = exports.generateSPKIFingerprint = exports.generateCACertificate = exports.MOCKTTP_PARAM_REF = exports.completionCheckers = exports.webSocketHandlerDefinitions = exports.webSocketHandlers = exports.requestHandlerDefinitions = exports.requestHandlers = exports.matchers = void 0;
const mockttp_server_1 = require("./server/mockttp-server");
const mockttp_client_1 = require("./client/mockttp-client");
const mockttp_admin_server_1 = require("./admin/mockttp-admin-server");
// Export the core type definitions:
__exportStar(require("./types"), exports);
// Export rule data builders & type definitions:
const matchers = require("./rules/matchers");
exports.matchers = matchers;
const requestHandlers = require("./rules/requests/request-handlers");
exports.requestHandlers = requestHandlers;
const requestHandlerDefinitions = require("./rules/requests/request-handler-definitions");
exports.requestHandlerDefinitions = requestHandlerDefinitions;
const webSocketHandlers = require("./rules/websockets/websocket-handlers");
exports.webSocketHandlers = webSocketHandlers;
const webSocketHandlerDefinitions = require("./rules/websockets/websocket-handler-definitions");
exports.webSocketHandlerDefinitions = webSocketHandlerDefinitions;
const completionCheckers = require("./rules/completion-checkers");
exports.completionCheckers = completionCheckers;
var rule_parameters_1 = require("./rules/rule-parameters");
Object.defineProperty(exports, "MOCKTTP_PARAM_REF", { enumerable: true, get: function () { return rule_parameters_1.MOCKTTP_PARAM_REF; } });
// Export TLS utility methods:
var tls_1 = require("./util/tls");
Object.defineProperty(exports, "generateCACertificate", { enumerable: true, get: function () { return tls_1.generateCACertificate; } });
Object.defineProperty(exports, "generateSPKIFingerprint", { enumerable: true, get: function () { return tls_1.generateSPKIFingerprint; } });
// Export the core API:
/**
 * Get a Mockttp instance on the local machine.
 *
 * In most simple environments, you can call this method directly and immediately
 * get a Mockttp instance and start mocking servers.
 *
 * In node, the mocked servers will run in process and require no further setup.
 *
 * In browsers this is an alias for getRemote. You'll need to start a Mockttp admin server
 * outside your tests before calling this, which will create and manage your fake servers
 * outside the browser.
 */
function getLocal(options = {}) {
    return new mockttp_server_1.MockttpServer(options);
}
exports.getLocal = getLocal;
/**
 * Get a Mockttp instance, controlled through a Mockttp admin server.
 *
 * This connects to a Mockttp admin server, and uses that to start
 * and stop mock servers.
 */
function getRemote(options = {}) {
    return new mockttp_client_1.MockttpClient(options);
}
exports.getRemote = getRemote;
/**
 * Get a Mockttp admin server, which can be used with a Mockttp remote client to create
 * & manage Mockttp instances either from remote machines or from local environments
 * that lack necessary capabilities, e.g. to use Mockttp from inside a browser.
 *
 * This function exists so you can set up these servers programmatically, but for most
 * usage you can just run your tests via the `mockttp` binary, which will automatically
 * start and stop an admin server for you:
 *
 * ```
 * mockttp -c <your test command>
 * ```
 */
function getAdminServer(options = {}) {
    return new mockttp_admin_server_1.MockttpAdminServer(options);
}
exports.getAdminServer = getAdminServer;
const admin_client_1 = require("./client/admin-client");
Object.defineProperty(exports, "resetAdminServer", { enumerable: true, get: function () { return admin_client_1.resetAdminServer; } });
/**
 * This API is not yet stable, and is intended for internal use only. It may change in future
 * in minor versions without warning.
 *
 * These generic pluggable admin components allow composing an admin server and client that
 * are capable of managing arbitrary mock protocols, including Mockttp but also others depending
 * on the admin plugins used. To use Mockttp, combine this with the MockttpPluggableAdmin API.
 * @category Internal
 */
exports.PluggableAdmin = require("./pluggable-admin-api/pluggable-admin");
/**
 * This API is not yet stable, and is intended for internal use only. It may change in future
 * in minor versions without warning.
 *
 * These plugin components can be applied to the PluggableAdmin API to create a remotely
 * controlable mock management server that can mock HTTP in addition to protocols from
 * other plugins.
 * @category Internal
 */
exports.MockttpPluggableAdmin = require("./pluggable-admin-api/mockttp-pluggable-admin");
//# sourceMappingURL=main.js.map