"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockttpPluggableAdmin = exports.PluggableAdmin = exports.resetAdminServer = exports.getAdminServer = exports.getRemote = exports.getLocal = exports.MOCKTTP_PARAM_REF = exports.webSocketHandlers = exports.requestHandlers = exports.completionCheckers = exports.webSocketHandlerDefinitions = exports.requestHandlerDefinitions = exports.matchers = exports.RulePriority = exports.Method = void 0;
const mockttp_client_1 = require("./client/mockttp-client");
var types_1 = require("./types");
Object.defineProperty(exports, "Method", { enumerable: true, get: function () { return types_1.Method; } });
Object.defineProperty(exports, "RulePriority", { enumerable: true, get: function () { return types_1.RulePriority; } });
// Export rule data builders:
const matchers = require("./rules/matchers");
exports.matchers = matchers;
const requestHandlerDefinitions = require("./rules/requests/request-handler-definitions");
exports.requestHandlerDefinitions = requestHandlerDefinitions;
const webSocketHandlerDefinitions = require("./rules/websockets/websocket-handler-definitions");
exports.webSocketHandlerDefinitions = webSocketHandlerDefinitions;
const completionCheckers = require("./rules/completion-checkers");
exports.completionCheckers = completionCheckers;
// We re-export definitions to pretend they're real handlers in the browser. This should be safe
// because the missing methods (i.e. handle()) were always unusable in non-Node environments anyway.
// In practice though, new browser code using this should actively use requestHandlerDefinitions instead.
// In future, we should probably expose definitions only for both browsers & node, but that's a
// breaking change.
exports.requestHandlers = {
    'SimpleHandler': requestHandlerDefinitions.SimpleHandlerDefinition,
    'CallbackHandler': requestHandlerDefinitions.CallbackHandlerDefinition,
    'StreamHandler': requestHandlerDefinitions.StreamHandlerDefinition,
    'FileHandler': requestHandlerDefinitions.FileHandlerDefinition,
    'PassThroughHandler': requestHandlerDefinitions.PassThroughHandlerDefinition,
    'CloseConnectionHandler': requestHandlerDefinitions.CloseConnectionHandlerDefinition,
    'TimeoutHandler': requestHandlerDefinitions.TimeoutHandlerDefinition,
    'HandlerLookup': requestHandlerDefinitions.HandlerDefinitionLookup
};
exports.webSocketHandlers = {
    'PassThroughWebSocketHandler': webSocketHandlerDefinitions.PassThroughWebSocketHandlerDefinition,
    'CloseConnectionHandler': webSocketHandlerDefinitions.CloseConnectionHandlerDefinition,
    'TimeoutHandler': webSocketHandlerDefinitions.TimeoutHandlerDefinition,
    'WsHandlerLookup': webSocketHandlerDefinitions.WsHandlerDefinitionLookup
};
var rule_parameters_1 = require("./rules/rule-parameters");
Object.defineProperty(exports, "MOCKTTP_PARAM_REF", { enumerable: true, get: function () { return rule_parameters_1.MOCKTTP_PARAM_REF; } });
// Export the core API:
function getLocal(options = {}) {
    return new mockttp_client_1.MockttpClient(options);
}
exports.getLocal = getLocal;
function getRemote(options = {}) {
    return new mockttp_client_1.MockttpClient(options);
}
exports.getRemote = getRemote;
function getAdminServer() {
    throw new Error('Cannot set up an admin server within a browser');
}
exports.getAdminServer = getAdminServer;
var admin_client_1 = require("./client/admin-client");
Object.defineProperty(exports, "resetAdminServer", { enumerable: true, get: function () { return admin_client_1.resetAdminServer; } });
exports.PluggableAdmin = require("./pluggable-admin-api/pluggable-admin");
exports.MockttpPluggableAdmin = require("./pluggable-admin-api/mockttp-pluggable-admin");
//# sourceMappingURL=main.browser.js.map