"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.introspectionQuery = exports.SchemaIntrospector = void 0;
const _ = require("lodash");
class SchemaIntrospector {
    constructor(adminServerSchema) {
        this.adminServerSchema = adminServerSchema;
    }
    queryTypeDefined(queryType) {
        return this.typeHasField('Query', queryType);
    }
    isTypeDefined(typeName) {
        return _.some(this.adminServerSchema.types, { name: typeName });
    }
    typeHasField(typeName, fieldName) {
        const type = _.find(this.adminServerSchema.types, { name: typeName });
        if (!type)
            return false;
        return !!_.find(type.fields, { name: fieldName });
    }
    asOptionalField(typeName, fieldName) {
        const possibleNames = !Array.isArray(typeName) ? [typeName] : typeName;
        const firstAvailableName = possibleNames.find((name) => this.isTypeDefined(name));
        if (!firstAvailableName)
            return '';
        return (this.typeHasField(firstAvailableName, fieldName))
            ? fieldName
            : '';
    }
    typeHasInputField(typeName, fieldName) {
        const type = _.find(this.adminServerSchema.types, { name: typeName });
        if (!type)
            return false;
        return !!_.find(type.inputFields, { name: fieldName });
    }
}
exports.SchemaIntrospector = SchemaIntrospector;
// Taken from src/utilities/introspectionQuery.js in GraphQL-js
// Copied directly, to avoid bundling the whole thing into frontend code.
exports.introspectionQuery = `
  query IntrospectionQuery {
    __schema {
      queryType { name }
      mutationType { name }
      subscriptionType { name }
      types {
        ...FullType
      }
      directives {
        name
        locations
        args {
          ...InputValue
        }
      }
    }
  }

  fragment FullType on __Type {
    kind
    name
    fields(includeDeprecated: true) {
      name
      args {
        ...InputValue
      }
      type {
        ...TypeRef
      }
      isDeprecated
      deprecationReason
    }
    inputFields {
      ...InputValue
    }
    interfaces {
      ...TypeRef
    }
    enumValues(includeDeprecated: true) {
      name
      isDeprecated
      deprecationReason
    }
    possibleTypes {
      ...TypeRef
    }
  }

  fragment InputValue on __InputValue {
    name
    type { ...TypeRef }
    defaultValue
  }

  fragment TypeRef on __Type {
    kind
    name
    ofType {
      kind
      name
      ofType {
        kind
        name
        ofType {
          kind
          name
          ofType {
            kind
            name
            ofType {
              kind
              name
              ofType {
                kind
                name
                ofType {
                  kind
                  name
                }
              }
            }
          }
        }
      }
    }
  }
`;
//# sourceMappingURL=schema-introspection.js.map