/// <reference types="node" />
import * as stream from 'stream';
import { MockedEndpoint, MockedEndpointData } from "../types";
import { AdminQuery } from './admin-query';
import { SchemaIntrospector } from './schema-introspection';
import type { RequestRuleData } from "../rules/requests/request-rule";
import type { WebSocketRuleData } from '../rules/websockets/websocket-rule';
import { SubscribableEvent } from '../mockttp';
/**
 * This is part of Mockttp's experimental 'pluggable admin' API. This may change
 * unpredictably, even in minor releases.
 *
 * @internal
 */
export declare class MockttpAdminRequestBuilder {
    private schema;
    constructor(schema: SchemaIntrospector);
    buildAddRequestRulesQuery(rules: Array<RequestRuleData>, reset: boolean, adminStream: stream.Duplex): AdminQuery<{
        endpoints: Array<{
            id: string;
            explanation?: string;
        }>;
    }, MockedEndpoint[]>;
    buildAddWebSocketRulesQuery(rules: Array<WebSocketRuleData>, reset: boolean, adminStream: stream.Duplex): AdminQuery<{
        endpoints: Array<{
            id: string;
            explanation?: string;
        }>;
    }, MockedEndpoint[]>;
    buildMockedEndpointsQuery(): AdminQuery<{
        mockedEndpoints: MockedEndpointData[];
    }, MockedEndpoint[]>;
    buildPendingEndpointsQuery(): AdminQuery<{
        pendingEndpoints: MockedEndpointData[];
    }, MockedEndpoint[]>;
    buildSubscriptionRequest<T>(event: SubscribableEvent): AdminQuery<unknown, T> | undefined;
    private getEndpointDataGetter;
}
//# sourceMappingURL=mockttp-admin-request-builder.d.ts.map