"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockedEndpointClient = void 0;
class MockedEndpointClient {
    constructor(id, explanation, endpointDataGetter) {
        this.id = id;
        this.explanation = explanation;
        this.endpointDataGetter = endpointDataGetter;
    }
    async getMockedEndpointData() {
        const mockedEndpointData = await this.endpointDataGetter();
        if (mockedEndpointData === null)
            throw new Error("Can't get seen requests for unknown mocked endpoint");
        else
            return mockedEndpointData;
    }
    async getSeenRequests() {
        return (await this.getMockedEndpointData()).seenRequests;
    }
    async isPending() {
        return (await this.getMockedEndpointData()).isPending;
    }
    toString() {
        if (this.explanation) {
            return "Mocked endpoint: " + this.explanation;
        }
        else {
            return Object.toString.call(this);
        }
    }
}
exports.MockedEndpointClient = MockedEndpointClient;
//# sourceMappingURL=mocked-endpoint-client.js.map