"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSingleSelectedFieldName = void 0;
function isFieldSelection(selection) {
    return selection.kind === 'Field';
}
function getQuerySelectionNode(gqlQuery) {
    const { definitions } = gqlQuery;
    if (definitions.length !== 1 || definitions[0].kind !== 'OperationDefinition') {
        throw new Error("Admin queries must be defined as a single operation definition");
    }
    return definitions[0].selectionSet;
}
// Enforces that the query selects only one field (this is relevant for subscriptions),
// and extracts and returns the name of that field.
function getSingleSelectedFieldName(query) {
    const selectedFieldNames = getQuerySelectionNode(query.query)
        .selections
        .filter(isFieldSelection)
        .map(selection => selection.name.value);
    if (selectedFieldNames.length !== 1) {
        throw new Error(`This admin query must select only one field, but it selects ${selectedFieldNames.length}: ${selectedFieldNames.join(', ')}`);
    }
    return selectedFieldNames[0];
}
exports.getSingleSelectedFieldName = getSingleSelectedFieldName;
//# sourceMappingURL=admin-query.js.map