"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseAnyAst = exports.astToObject = void 0;
const _ = require("lodash");
const graphql_1 = require("graphql");
function astToObject(ast) {
    return _.zipObject(ast.fields.map((f) => f.name.value), ast.fields.map((f) => parseAnyAst(f.value)));
}
exports.astToObject = astToObject;
function parseAnyAst(ast) {
    switch (ast.kind) {
        case graphql_1.Kind.OBJECT:
            return astToObject(ast);
        case graphql_1.Kind.LIST:
            return ast.values.map(parseAnyAst);
        case graphql_1.Kind.BOOLEAN:
        case graphql_1.Kind.ENUM:
        case graphql_1.Kind.FLOAT:
        case graphql_1.Kind.INT:
        case graphql_1.Kind.STRING:
            return ast.value;
        case graphql_1.Kind.NULL:
            return null;
        case graphql_1.Kind.VARIABLE:
            throw new Error("No idea what parsing a 'variable' means");
    }
}
exports.parseAnyAst = parseAnyAst;
//# sourceMappingURL=graphql-utils.js.map