/// <reference types="node" />
import { Duplex } from "stream";
import { DocumentNode } from "graphql";
import { IResolvers } from "@graphql-tools/utils";
import { MaybePromise } from "../util/type-utils";
export interface AdminPlugin<StartParams, ClientResponse> {
    start: (options: StartParams) => MaybePromise<ClientResponse>;
    stop: () => MaybePromise<void>;
    reset?: () => MaybePromise<void>;
    enableDebug?: () => void;
    schema: DocumentNode | string;
    buildResolvers: (stream: Duplex, ruleParameters: {
        [key: string]: any;
    }) => IResolvers;
}
export declare type AdminPluginConstructor<Plugin> = {
    new (): Plugin;
};
export declare type PluginStartParams<Plugin> = Plugin extends AdminPlugin<infer StartParams, any> ? StartParams : never;
export declare type PluginClientResponse<Plugin> = Plugin extends AdminPlugin<any, infer ClientResponse> ? ClientResponse : never;
export declare type PluginConstructorMap<Plugins> = {
    [key in keyof Plugins]: AdminPluginConstructor<Plugins[key]>;
};
export declare type PluginStartParamsMap<Plugins> = {
    [key in keyof Plugins]: PluginStartParams<Plugins[key]>;
};
export declare type PluginClientResponsesMap<Plugins> = {
    [key in keyof Plugins]: PluginClientResponse<Plugins[key]>;
};
//# sourceMappingURL=admin-plugin-types.d.ts.map