/// <reference types="node" />
import * as zlib from 'zlib';
export declare type SUPPORTED_ENCODING = 'identity' | 'gzip' | 'x-gzip' | 'deflate' | 'x-deflate' | 'br' | 'zstd' | 'base64';
export declare const gzip: typeof zlib.gzip.__promisify__;
export declare const gunzip: typeof zlib.gunzip.__promisify__;
export declare const deflate: typeof zlib.deflate.__promisify__;
export declare const inflate: typeof zlib.inflate.__promisify__;
export declare const inflateRaw: typeof zlib.inflateRaw.__promisify__;
export declare const brotliCompress: (buffer: Uint8Array, level?: number | undefined) => Promise<Uint8Array>;
export declare const brotliDecompress: typeof zlib.brotliDecompress.__promisify__ | ((buffer: Uint8Array) => Promise<Uint8Array>);
export declare const zstdCompress: (buffer: Uint8Array, level?: number | undefined) => Promise<Uint8Array>;
export declare const zstdDecompress: (buffer: Uint8Array) => Promise<Uint8Array>;
declare const encodeBase64Promisified: (arg1: Uint8Array) => Promise<Uint8Array>;
export { encodeBase64Promisified as encodeBase64 };
declare const decodeBase64Promisified: (arg1: Uint8Array) => Promise<Uint8Array>;
export { decodeBase64Promisified as decodeBase64 };
/**
 * Decodes a buffer, using the encodings as specified in a content-encoding header. Returns
 * a Buffer instance in Node, or a Uint8Array in a browser.
 *
 * Throws if any unrecognized/unavailable content-encoding is found.
 */
export declare function decodeBuffer(body: Uint8Array | ArrayBuffer, encoding: string | string[] | undefined): Promise<Buffer>;
/**
 * Decodes a buffer, using the encodings as specified in a content-encoding header, synchronously.
 * Returns a Buffer instance in Node, or a Uint8Array in a browser.
 *
 * Zstandard and Brotli decoding are not be supported in synchronous usage.
 *
 * Throws if any unrecognized/unavailable content-encoding is found.
 *
 * @deprecated This is here for convenience with some existing APIs, but for performance & consistency
 * async usage with decodeBuffer is preferable.
 */
export declare function decodeBufferSync(body: Uint8Array | ArrayBuffer, encoding: string | string[] | undefined): Buffer;
/**
 * Encodes a buffer, given a single encoding name (as used in content-encoding headers), and an optional
 * level. Returns a Buffer instance in Node, or a Uint8Array in a browser.
 *
 * Throws if an unrecognized/unavailable encoding is specified
 */
export declare function encodeBuffer(body: Uint8Array | ArrayBuffer, encoding: SUPPORTED_ENCODING, options?: {
    level?: number;
}): Promise<Buffer>;
