/* tslint:disable */
/* eslint-disable */
/**
* @param {Uint8Array} buf
* @returns {Uint8Array}
*/
export function decompress(buf: Uint8Array): Uint8Array;
/**
*/
export enum BrotliStreamResult {
/**
* The stream is just initialized and no input is provided currently.
* `BrotliResult` uses `ResultFailure = 0`, but as we will convert `ResultFailure` to a negative actual error code,
* 0 is reused as no input currently.
* As for Brotli compressing, since offical API does not provide a way to retrieve a detailed error code, -1 is used.
*/
  Init,
  ResultSuccess,
  NeedsMoreInput,
  NeedsMoreOutput,
}


type Options = {
    quality?: number
};

export function compress(buf: Uint8Array, options?: Options): Uint8Array;


/**
*/
export class CompressStream {
  free(): void;
/**
* @param {number | undefined} quality
*/
  constructor(quality?: number);
/**
* @param {Uint8Array | undefined} input_opt
* @param {number} output_size
* @returns {Uint8Array}
*/
  compress(input_opt: Uint8Array | undefined, output_size: number): Uint8Array;
/**
* @returns {number}
*/
  total_out(): number;
/**
* @returns {number}
*/
  result(): number;
/**
* @returns {number}
*/
  last_input_offset(): number;
}
/**
*/
export class DecompressStream {
  free(): void;
/**
*/
  constructor();
/**
* @param {Uint8Array} input
* @param {number} output_size
* @returns {Uint8Array}
*/
  decompress(input: Uint8Array, output_size: number): Uint8Array;
/**
* @returns {number}
*/
  total_out(): number;
/**
* @returns {number}
*/
  result(): number;
/**
* @returns {number}
*/
  last_input_offset(): number;
}
