import * as runtime from '../../../lib/runtime.js';
import type { InitOverride, ApiResponse } from '../../../lib/runtime.js';
import type { Connection, ConnectionCreate, ConnectionUpdate, GetConnections200ResponseOneOf, DeleteConnectionsByIdRequest, DeleteUsersByEmailRequest, GetConnectionsRequest, GetConnectionsByIdRequest, GetStatusRequest, PatchConnectionsByIdRequest } from '../models/index.js';
declare const BaseAPI: typeof runtime.BaseAPI;
/**
 *
 */
export declare class ConnectionsManager extends BaseAPI {
    /**
     * Deletes a connection and all its users.
     *
     * Delete a connection
     *
     * @throws {RequiredError}
     */
    delete(requestParameters: DeleteConnectionsByIdRequest, initOverrides?: InitOverride): Promise<ApiResponse<void>>;
    /**
     * Deletes a specified connection user by its email (you cannot delete all users from specific connection). Currently, only Database Connections are supported.
     *
     * Delete a connection user
     *
     * @throws {RequiredError}
     */
    deleteUserByEmail(requestParameters: DeleteUsersByEmailRequest, initOverrides?: InitOverride): Promise<ApiResponse<void>>;
    /**
     * Retrieves every connection matching the specified strategy. All connections are retrieved if no strategy is being specified. Accepts a list of fields to include or exclude in the resulting list of connection objects.
     * This endpoint supports two types of pagination:
     * - Offset pagination
     * - Checkpoint pagination
     *
     * Checkpoint pagination should be used if you need to retrieve more than 1000 connections.
     *
     * <h2>Checkpoint Pagination</h2>
     *
     * To search by checkpoint, use the following parameters:
     * - from: Optional id from which to start selection.
     * - take: The total amount of entries to retrieve when using the from parameter. Defaults to 50.
     *
     * The first time you call this endpoint using Checkpoint Pagination, you should omit the <code>from</code> parameter.
     * If there are more results, a <code>next</code> value will be included in the response. You can use this for subsequent API calls.
     * When <code>next</code> is no longer included in the response, this indicates there are no more pages remaining.
     *
     * Note: The <code>include_totals</code> parameter is not supported when using checkpoint pagination.
     * Get all connections
     *
     * @throws {RequiredError}
     */
    getAll(requestParameters: GetConnectionsRequest & {
        include_totals: true;
    }, initOverrides?: InitOverride): Promise<ApiResponse<GetConnections200ResponseOneOf>>;
    getAll(requestParameters?: GetConnectionsRequest, initOverrides?: InitOverride): Promise<ApiResponse<Array<Connection>>>;
    /**
     * Retrieves a connection by its <code>ID</code>.
     *
     * Get a connection
     *
     * @throws {RequiredError}
     */
    get(requestParameters: GetConnectionsByIdRequest, initOverrides?: InitOverride): Promise<ApiResponse<Connection>>;
    /**
     * Retrieves the status of an ad/ldap connection referenced by its <code>ID</code>. <code>200 OK</code> http status code response is returned  when the connection is online, otherwise a <code>404</code> status code is returned along with an error message
     * Check connection status
     *
     * @throws {RequiredError}
     */
    checkStatus(requestParameters: GetStatusRequest, initOverrides?: InitOverride): Promise<ApiResponse<void>>;
    /**
     * <b>Note:</b> if you use the options parameter, the whole options object will be overridden, so ensure that all parameters are present
     *
     * Update a connection
     *
     * @throws {RequiredError}
     */
    update(requestParameters: PatchConnectionsByIdRequest, bodyParameters: ConnectionUpdate, initOverrides?: InitOverride): Promise<ApiResponse<Connection>>;
    /**
     * Creates a new connection according to the JSON object received in <code>body</code>.
     *
     * Create a connection
     *
     * @throws {RequiredError}
     */
    create(bodyParameters: ConnectionCreate, initOverrides?: InitOverride): Promise<ApiResponse<Connection>>;
}
export {};
