/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
import * as net from 'net';
import * as tls from 'tls';
import * as http from 'http';
import * as https from 'https';
declare module 'net' {
    interface Socket {
        /**
         * Only preserved for types backward compat - always undefined in new releases.
         *
         * @deprecated
         */
        __httpPeekedData?: Buffer;
    }
}
export declare class Server extends net.Server {
    private _httpServer;
    private _http2Server;
    private _tlsServer;
    /**
     * Create an Httpolyglot instance with just a request listener to support plain-text
     * HTTP & HTTP/2 on the same port, with incoming TLS connections being closed immediately.
     */
    constructor(requestListener: http.RequestListener);
    /**
     * Call with a full TLS configuration to create a TLS+HTTP+HTTP/2 server, which can
     * support all protocols on the same port.
     */
    constructor(config: https.ServerOptions, requestListener: http.RequestListener);
    /**
     * Pass an existing TLS server, instead of TLS configuration, to create a TLS+HTTP+HTTP/2
     * server. All incoming TLS requests will be emitted as 'connection' events on the given
     * TLS server, and all 'secureConnection' events coming from the TLS server will be
     * handled according to the connection type detected on that socket.
     */
    constructor(tlsServer: tls.Server, requestListener: http.RequestListener);
    private connectionListener;
    private tlsListener;
    private http2Listener;
}
/**
 * Create an Httpolyglot instance with just a request listener to support plain-text
 * HTTP & HTTP/2 on the same port, with incoming TLS connections being closed immediately.
 */
export declare function createServer(requestListener: http.RequestListener): Server;
/**
 * Create an instance with a full TLS configuration to create a TLS+HTTP+HTTP/2 server, which can
 * support all protocols on the same port.
 */
export declare function createServer(tlsConfig: https.ServerOptions, requestListener: http.RequestListener): Server;
/**
* Create an instance around an existing TLS server, instead of TLS configuration, to create a
* TLS+HTTP+HTTP/2 server with custom TLS handling. All incoming TLS requests will be emitted as
* 'connection' events on the given TLS server, and all 'secureConnection' events coming from the
* TLS server will be handled according to the connection type detected on that socket.
*/
export declare function createServer(tlsServer: tls.Server, requestListener: http.RequestListener): Server;
