"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = atom;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var Atom = /*#__PURE__*/function () {
  function Atom(state) {
    _classCallCheck(this, Atom);
    this.state = state;
    this.watches = {};
  }
  return _createClass(Atom, [{
    key: "reset",
    value: function reset(state) {
      return this._change(state);
    }
  }, {
    key: "swap",
    value: function swap(f) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      return this._change(f.apply(void 0, [this.state].concat(args)));
    }
  }, {
    key: "deref",
    value: function deref() {
      return this.state;
    }
  }, {
    key: "addWatch",
    value: function addWatch(k, f) {
      // if (this.watches[key]) {
      //   console.warn(`adding a watch with an already registered key: ${k}`);
      // }
      this.watches[k] = f;
      return this;
    }
  }, {
    key: "removeWatch",
    value: function removeWatch(k) {
      // if (!this.watches[key]) {
      //   console.warn(`removing a watch with an unknown key: ${k}`);
      // }
      delete this.watches[k];
      return this;
    }
  }, {
    key: "_change",
    value: function _change(newState) {
      var state = this.state,
        watches = this.watches;
      this.state = newState;
      Object.keys(watches).forEach(function (k) {
        return watches[k](k, state, newState);
      });
      return this.state;
    }
  }]);
}();
function atom(state) {
  return new Atom(state);
}
