"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _input_wrap = _interopRequireDefault(require("./input_wrap"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
var ArrowIconSvg = function ArrowIconSvg() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    "aria-hidden": "true",
    focusable: "false",
    width: "5px",
    height: "10px",
    viewBox: "0 0 5 10",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg",
    xmlnsXlink: "http://www.w3.org/1999/xlink",
    className: "auth0-lock-icon-arrow"
  }, /*#__PURE__*/_react.default.createElement("g", {
    stroke: "none",
    strokeWidth: "1",
    fill: "none",
    fillRule: "evenodd"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "Lock",
    transform: "translate(-396.000000, -3521.000000)",
    fill: "#000000",
    opacity: "0.539999962"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "SMS",
    transform: "translate(153.000000, 3207.000000)"
  }, /*#__PURE__*/_react.default.createElement("g", {
    transform: "translate(35.000000, 299.000000)"
  }, /*#__PURE__*/_react.default.createElement("g", {
    transform: "translate(210.000000, 20.000000) rotate(-90.000000) translate(-210.000000, -20.000000) translate(198.000000, 8.000000)"
  }, /*#__PURE__*/_react.default.createElement("path", {
    id: "Shape",
    d: "M7,10 L12,15 L17,10 L7,10 Z"
  })))))));
};
var SelectInput = exports.default = /*#__PURE__*/function (_React$Component) {
  function SelectInput(props) {
    var _this;
    _classCallCheck(this, SelectInput);
    _this = _callSuper(this, SelectInput, [props]);
    _this.state = {};
    return _this;
  }
  _inherits(SelectInput, _React$Component);
  return _createClass(SelectInput, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        lockId = _this$props.lockId,
        iconUrl = _this$props.iconUrl,
        isValid = _this$props.isValid,
        label = _this$props.label,
        ariaLabel = _this$props.ariaLabel,
        name = _this$props.name,
        onClick = _this$props.onClick,
        placeholder = _this$props.placeholder;
      var icon = this.props.icon;
      var focused = this.state.focused;
      var limitedValue = label || placeholder;
      if (limitedValue.length > 23) {
        limitedValue = "".concat(limitedValue.substr(0, 20), "...");
      }
      if (!icon && typeof iconUrl === 'string' && iconUrl) {
        icon = /*#__PURE__*/_react.default.createElement("img", {
          className: "auth0-lock-custom-icon",
          alt: ariaLabel || name,
          src: iconUrl
        });
      }
      var className = 'auth0-lock-input auth0-lock-input-location';
      if (!label) className += ' auth0-lock-input-with-placeholder';
      return /*#__PURE__*/_react.default.createElement(_input_wrap.default, {
        focused: focused,
        isValid: isValid,
        name: "location",
        icon: icon
      }, /*#__PURE__*/_react.default.createElement("input", {
        id: "".concat(lockId, "-").concat(name),
        type: "button",
        name: name,
        className: className,
        value: limitedValue,
        onFocus: this.handleFocus.bind(this),
        onBlur: this.handleBlur.bind(this),
        onKeyDown: this.handleKeyDown.bind(this),
        onClick: onClick,
        "aria-label": ariaLabel || name,
        "aria-invalid": !isValid
      }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(ArrowIconSvg, null)));
    }
  }, {
    key: "handleFocus",
    value: function handleFocus() {
      this.setState({
        focused: true
      });
    }
  }, {
    key: "handleBlur",
    value: function handleBlur() {
      this.setState({
        focused: false
      });
    }
  }, {
    key: "handleKeyDown",
    value: function handleKeyDown(e) {
      if (e.key !== 'Tab') {
        e.preventDefault();
      }
      if (e.key === 'ArrowDown') {
        return this.props.onClick();
      }
      if (e.keyCode >= 65 && e.keyCode <= 90) {
        return this.props.onClick(String.fromCharCode(e.keyCode).toLowerCase());
      }
    }
  }]);
}(_react.default.Component); // TODO: specify propTypes
