"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IconSvg = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _input_wrap = _interopRequireDefault(require("./input_wrap"));
var _password_strength = _interopRequireDefault(require("./password/password_strength"));
var l = _interopRequireWildcard(require("../../core/index"));
var _excluded = ["invalidHint", "showPasswordStrengthMessage", "isValid", "onChange", "policy", "strengthMessages", "value", "showPassword", "lock"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } } return target; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var IconSvg = exports.IconSvg = /*#__PURE__*/_react.default.createElement("svg", {
  "aria-hidden": "true",
  focusable: "false",
  width: "11px",
  height: "14px",
  viewBox: "0 0 13 16",
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg",
  xmlnsXlink: "http://www.w3.org/1999/xlink",
  className: "auth0-lock-icon auth0-lock-icon-box"
}, /*#__PURE__*/_react.default.createElement("g", {
  stroke: "none",
  strokeWidth: "1",
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/_react.default.createElement("g", {
  transform: "translate(-288.000000, -1508.000000)",
  fill: "#888888"
}, /*#__PURE__*/_react.default.createElement("path", {
  d: "M299,1523.998 L290,1523.998 C288.896,1523.998 288,1523.102 288,1521.999 L288,1515.999 C288,1514.895 288.896,1513.998 290,1513.998 L290,1513.998 L290,1512.499 C290,1510.015 292.015,1507.999 294.5,1507.999 C296.985,1507.999 299,1510.015 299,1512.499 L299,1513.999 C300.104,1513.999 301,1514.895 301,1515.999 L301,1521.999 C301,1523.103 300.104,1523.998 299,1523.998 L299,1523.998 Z M298,1512.499 C298,1510.566 296.433,1508.999 294.5,1508.999 C292.567,1508.999 291,1510.566 291,1512.499 L291,1513.998 L298,1513.998 L298,1512.499 L298,1512.499 Z M300,1515.999 C300,1515.446 299.552,1514.998 299,1514.998 L290,1514.998 C289.447,1514.998 289,1515.446 289,1515.999 L289,1521.999 C289,1522.551 289.447,1522.998 290,1522.998 L299,1522.998 C299.552,1522.998 300,1522.551 300,1521.999 L300,1515.999 L300,1515.999 Z M294.5,1520.998 C294.224,1520.998 294,1520.774 294,1520.498 L294,1517.498 C294,1517.223 294.224,1516.999 294.5,1516.999 C294.776,1516.999 295,1517.223 295,1517.498 L295,1520.498 C295,1520.774 294.776,1520.998 294.5,1520.998 L294.5,1520.998 Z"
}))));
var PasswordInput = exports.default = /*#__PURE__*/function (_React$Component) {
  function PasswordInput(props) {
    var _this;
    _classCallCheck(this, PasswordInput);
    _this = _callSuper(this, PasswordInput, [props]);
    _this.state = {};
    return _this;
  }
  _inherits(PasswordInput, _React$Component);
  return _createClass(PasswordInput, [{
    key: "focus",
    value: function focus() {
      this.refs.input && this.refs.input.focus();
    }
  }, {
    key: "hasFocus",
    value: function hasFocus() {
      return this.state.focused;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        invalidHint = _this$props.invalidHint,
        showPasswordStrengthMessage = _this$props.showPasswordStrengthMessage,
        isValid = _this$props.isValid,
        onChange = _this$props.onChange,
        policy = _this$props.policy,
        strengthMessages = _this$props.strengthMessages,
        value = _this$props.value,
        showPassword = _this$props.showPassword,
        lock = _this$props.lock,
        props = _objectWithoutProperties(_this$props, _excluded);
      var _this$state = this.state,
        focused = _this$state.focused,
        changing = _this$state.changing;
      var allowPasswordAutocomplete = l.ui.allowPasswordAutocomplete(lock);
      var passwordStrength = policy && focused && changing && showPasswordStrengthMessage ? /*#__PURE__*/_react.default.createElement(_password_strength.default, {
        messages: strengthMessages,
        password: value,
        policy: policy
      }) : null;
      return /*#__PURE__*/_react.default.createElement(_input_wrap.default, {
        after: passwordStrength,
        focused: focused,
        invalidHint: invalidHint,
        isValid: isValid,
        name: "password",
        icon: IconSvg
      }, /*#__PURE__*/_react.default.createElement("input", _extends({
        ref: "input",
        type: showPassword ? 'text' : 'password',
        id: "".concat(l.id(lock), "-password"),
        name: "password",
        className: "auth0-lock-input",
        autoComplete: allowPasswordAutocomplete ? 'on' : 'off',
        autoCapitalize: "off",
        autoCorrect: "off",
        spellCheck: "false",
        onChange: this.handleOnChange.bind(this),
        onFocus: this.handleFocus.bind(this),
        onBlur: this.handleBlur.bind(this),
        value: value,
        "aria-label": "Password",
        "aria-invalid": !isValid,
        "aria-describedby": !isValid && !policy && invalidHint ? "auth0-lock-error-msg-password" : undefined
      }, props)));
    }
  }, {
    key: "handleOnChange",
    value: function handleOnChange(e) {
      var state = this.state;
      state.changing = true;
      this.setState(state);
      if (this.props.onChange) {
        this.props.onChange(e);
      }
    }
  }, {
    key: "handleFocus",
    value: function handleFocus() {
      this.setState({
        focused: true
      });
    }
  }, {
    key: "handleBlur",
    value: function handleBlur() {
      this.setState({
        focused: false
      });
    }
  }]);
}(_react.default.Component);
_defineProperty(PasswordInput, "propTypes", {
  invalidHint: _propTypes.default.string.isRequired,
  showPasswordStrengthMessage: _propTypes.default.bool.isRequired,
  isValid: _propTypes.default.bool.isRequired,
  onChange: _propTypes.default.func.isRequired,
  placeholder: _propTypes.default.string,
  policy: _propTypes.default.object,
  strengthMessages: _propTypes.default.object,
  value: _propTypes.default.string.isRequired,
  showPassword: _propTypes.default.bool.isRequired,
  lock: _propTypes.default.object.isRequired
});
