"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _policy = _interopRequireDefault(require("password-sheriff/lib/policy"));
var _format = _interopRequireDefault(require("../../../utils/format"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
var PasswordStrength = exports.default = /*#__PURE__*/function (_React$Component) {
  function PasswordStrength() {
    _classCallCheck(this, PasswordStrength);
    return _callSuper(this, PasswordStrength, arguments);
  }
  _inherits(PasswordStrength, _React$Component);
  return _createClass(PasswordStrength, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        password = _this$props.password,
        policy = _this$props.policy,
        messages = _this$props.messages;
      var analysis = new _policy.default(policy.toJS()).missing(password);
      // TODO: add a component for fadeIn / fadeOut animations?
      var className = 'auth0-lock-password-strength animated ' + (!analysis.verified ? 'fadeIn' : 'fadeOut');
      var prepareMessage = function prepareMessage(items) {
        items && items.forEach(function (o) {
          if (messages[o.code]) {
            o.message = messages[o.code];
          }
          o.message = _format.default.apply(void 0, [o.message].concat(_toConsumableArray(o.format || [])));
          if (o.items) {
            prepareMessage(o.items);
          }
        });
      };
      prepareMessage(analysis.rules);
      return /*#__PURE__*/_react.default.createElement("div", {
        className: className
      }, /*#__PURE__*/_react.default.createElement(List, {
        items: analysis.rules
      }));
    }
  }]);
}(_react.default.Component);
PasswordStrength.propTypes = {
  messages: _propTypes.default.object.isRequired,
  password: _propTypes.default.string.isRequired,
  policy: _propTypes.default.object.isRequired
};
PasswordStrength.defaultProps = {
  messages: {}
};
var List = /*#__PURE__*/function (_React$Component2) {
  function List() {
    _classCallCheck(this, List);
    return _callSuper(this, List, arguments);
  }
  _inherits(List, _React$Component2);
  return _createClass(List, [{
    key: "render",
    value: function render() {
      var items = this.props.items;
      return items && items.length ? /*#__PURE__*/_react.default.createElement("ul", null, items.map(function (x, i) {
        return /*#__PURE__*/_react.default.createElement(Item, _extends({}, x, {
          key: i
        }));
      })) : null;
    }
  }]);
}(_react.default.Component);
List.propTypes = {
  items: _propTypes.default.arrayOf(_propTypes.default.object)
};
var Item = /*#__PURE__*/function (_React$Component3) {
  function Item() {
    _classCallCheck(this, Item);
    return _callSuper(this, Item, arguments);
  }
  _inherits(Item, _React$Component3);
  return _createClass(Item, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        items = _this$props2.items,
        message = _this$props2.message,
        verified = _this$props2.verified;
      var className = verified ? 'auth0-lock-checked' : '';
      return /*#__PURE__*/_react.default.createElement("li", {
        className: className
      }, /*#__PURE__*/_react.default.createElement("span", null, message), /*#__PURE__*/_react.default.createElement(List, {
        items: items
      }));
    }
  }]);
}(_react.default.Component);
Item.propTypes = {
  items: _propTypes.default.array,
  message: _propTypes.default.string.isRequired,
  verified: _propTypes.default.bool.isRequired
};
