"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var AuthButton = function AuthButton(props) {
  var label = props.label,
    onClick = props.onClick,
    strategy = props.strategy,
    icon = props.icon,
    primaryColor = props.primaryColor,
    foregroundColor = props.foregroundColor;
  var backgroundStyle = primaryColor ? {
    backgroundColor: primaryColor
  } : {};
  var foregroundStyle = foregroundColor ? {
    color: foregroundColor
  } : {};
  var iconStyle = icon ? {
    backgroundImage: "url('".concat(icon, "')")
  } : {};
  return /*#__PURE__*/_react.default.createElement("a", {
    className: "auth0-lock-social-button auth0-lock-social-big-button",
    "data-provider": strategy,
    onClick: onClick,
    style: backgroundStyle,
    type: "button"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "auth0-lock-social-button-icon",
    style: iconStyle
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "auth0-lock-social-button-text",
    style: foregroundStyle
  }, label));
};
AuthButton.propTypes = {
  disabled: _propTypes.default.bool.isRequired,
  label: _propTypes.default.string.isRequired,
  onClick: _propTypes.default.func.isRequired,
  strategy: _propTypes.default.string.isRequired,
  icon: _propTypes.default.string,
  primaryColor: _propTypes.default.string,
  foregroundColor: _propTypes.default.string
};
AuthButton.defaultProps = {
  disabled: false
};
var _default = exports.default = AuthButton;
