"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _CSSCore = _interopRequireDefault(require("../../CSSCore"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
var Slider = exports.default = /*#__PURE__*/function (_React$Component) {
  function Slider(props) {
    var _this;
    _classCallCheck(this, Slider);
    _this = _callSuper(this, Slider, [props]);
    _this.state = {
      children: {
        current: props.children
      }
    };
    return _this;
  }

  // eslint-disable-next-line react/no-deprecated
  _inherits(Slider, _React$Component);
  return _createClass(Slider, [{
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      // TODO: take a prop to identify what are we rendering instead of
      // inferring it from children keys so we can accept more than one
      // child (we are already wrapping them).
      if (this.state.children.current.key != nextProps.children.key) {
        this.setState({
          children: {
            current: nextProps.children,
            prev: this.state.children.current
          },
          transitionName: this.props.transitionName
        });
        this.animate = true;
      } else if (!this.timeout) {
        this.setState({
          children: {
            current: nextProps.children
          },
          transitionName: nextProps.transitionName
        });
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this2 = this;
      if (this.animate) {
        this.animate = false;
        var transitionName = this.state.transitionName;
        var _this$state$children = this.state.children,
          current = _this$state$children.current,
          prev = _this$state$children.prev;
        var reverse = this.props.reverse;
        var currentComponent = this.refs[current.key];
        var prevComponent = this.refs[prev.key];
        var transition = function transition(component, className, delay) {
          // eslint-disable-next-line
          var node = _reactDom.default.findDOMNode(component);
          var activeClassName = "".concat(className, "-active");
          _CSSCore.default.addClass(node, className);
          setTimeout(function () {
            return _CSSCore.default.addClass(node, activeClassName);
          }, 17);
          if (delay) {
            setTimeout(function () {
              _CSSCore.default.removeClass(node, className);
              _CSSCore.default.removeClass(node, activeClassName);
            }, delay);
          }
        };
        var callback = function callback(slide) {
          currentComponent.componentWillSlideIn(slide);
          var classNamePrefix = reverse ? 'reverse-' : '';
          transition(currentComponent, "".concat(classNamePrefix).concat(transitionName, "-enter"), _this2.props.delay);
          transition(prevComponent, "".concat(classNamePrefix).concat(transitionName, "-exit"));
          _this2.timeout = setTimeout(function () {
            var _context;
            _this2.setState({
              children: {
                current: _this2.state.children.current
              },
              transitionName: _this2.props.transitionName
            });
            currentComponent.componentDidSlideIn((_context = _this2.props).onDidAppear.bind(_context));
            _this2.props.onDidSlide();
            _this2.timeout = null;
          }, _this2.props.delay);
        };
        this.props.onWillSlide();
        prevComponent.componentWillSlideOut(callback);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.timeout) clearTimeout(this.timeout);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$state$children2 = this.state.children,
        current = _this$state$children2.current,
        prev = _this$state$children2.prev;
      var children = prev ? [current, prev] : [current];
      var childrenToRender = children.map(function (child) {
        return /*#__PURE__*/_react.default.cloneElement( /*#__PURE__*/_react.default.createElement(Child, {}, child), {
          ref: child.key,
          key: child.key
        });
      });
      return /*#__PURE__*/_react.default.createElement(this.props.component, {}, childrenToRender);
    }
  }]);
}(_react.default.Component);
Slider.propTypes = {
  children: _propTypes.default.node.isRequired,
  component: _propTypes.default.string,
  delay: _propTypes.default.number.isRequired,
  onDidAppear: _propTypes.default.func.isRequired,
  onDidSlide: _propTypes.default.func.isRequired,
  onWillSlide: _propTypes.default.func.isRequired,
  reverse: _propTypes.default.bool.isRequired,
  transitionName: _propTypes.default.string.isRequired
};
Slider.defaultProps = {
  component: 'span',
  onDidAppear: function onDidAppear() {},
  onDidSlide: function onDidSlide() {},
  onWillSlide: function onWillSlide() {},
  reverse: false
};
var Child = /*#__PURE__*/function (_React$Component2) {
  function Child(props) {
    var _this3;
    _classCallCheck(this, Child);
    _this3 = _callSuper(this, Child, [props]);
    _defineProperty(_this3, "node", void 0);
    _this3.state = {
      height: '',
      originalHeight: '',
      show: true
    };
    return _this3;
  }
  _inherits(Child, _React$Component2);
  return _createClass(Child, [{
    key: "componentWillSlideIn",
    value: function componentWillSlideIn(slide) {
      this.setState({
        height: slide.height,
        originalHeight: parseInt(window.getComputedStyle(this.node, null).height, 10),
        show: false
      });
    }
  }, {
    key: "componentDidSlideIn",
    value: function componentDidSlideIn(cb) {
      var _this4 = this;
      var _this$state = this.state,
        height = _this$state.height,
        originalHeight = _this$state.originalHeight;
      if (height === originalHeight) {
        this.setState({
          show: true,
          height: ''
        });
        cb();
      } else {
        this.cb = cb;
        var frames = 10;
        var count = 0;
        var current = height;
        var last = originalHeight;
        var step = Math.abs(current - last) / frames;
        var dir = current < last ? 1 : -1;
        var dh = step * dir;

        // TODO: rAF
        this.t = setInterval(function () {
          if (count < frames - 1) {
            _this4.setState({
              height: current,
              animating: true
            });
            current += dh;
            count++;
          } else {
            clearInterval(_this4.t);
            delete _this4.t;
            _this4.setState({
              height: '',
              show: true
            });
            _this4.cb();
          }
        }, 17);
      }
    }
  }, {
    key: "componentWillSlideOut",
    value: function componentWillSlideOut(cb) {
      var size = window.getComputedStyle(this.node, null).height;
      cb({
        height: parseInt(size, 10),
        reverse: this.reverse
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.t) {
        clearInterval(this.t);
        this.cb();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this5 = this;
      var children = this.props.children;
      var _this$state2 = this.state,
        height = _this$state2.height,
        show = _this$state2.show;
      return /*#__PURE__*/_react.default.createElement("div", {
        ref: function ref(node) {
          return _this5.node = node;
        },
        style: height ? {
          height: height + 'px'
        } : {}
      }, /*#__PURE__*/_react.default.createElement("div", {
        style: {
          visibility: show ? 'inherit' : 'hidden'
        }
      }, children));
    }
  }]);
}(_react.default.Component);
Child.propTypes = {
  children: _propTypes.default.node.isRequired
};
