"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _button = require("./button");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
var Header = exports.default = /*#__PURE__*/function (_React$Component) {
  function Header() {
    _classCallCheck(this, Header);
    return _callSuper(this, Header, arguments);
  }
  _inherits(Header, _React$Component);
  return _createClass(Header, [{
    key: "getDOMNode",
    value: function getDOMNode() {
      return _reactDom.default.findDOMNode(this);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        backHandler = _this$props.backHandler,
        backgroundColor = _this$props.backgroundColor,
        backgroundUrl = _this$props.backgroundUrl,
        logoUrl = _this$props.logoUrl,
        name = _this$props.name,
        title = _this$props.title;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-header"
      }, backHandler && /*#__PURE__*/_react.default.createElement(_button.BackButton, {
        onClick: backHandler
      }), /*#__PURE__*/_react.default.createElement(Background, {
        imageUrl: backgroundUrl,
        backgroundColor: backgroundColor,
        grayScale: !!name
      }), /*#__PURE__*/_react.default.createElement(Welcome, {
        title: title,
        name: name,
        imageUrl: name ? undefined : logoUrl
      }));
    }
  }]);
}(_react.default.Component);
Header.propTypes = {
  backgroundUrl: _propTypes.default.string,
  logoUrl: _propTypes.default.string,
  name: _propTypes.default.string
};
var Welcome = /*#__PURE__*/function (_React$Component2) {
  function Welcome() {
    var _this;
    _classCallCheck(this, Welcome);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, Welcome, [].concat(args));
    // Cause a reflow when the image is loaded to fix an issue with the Lock content sometimes
    // not rendering in a popup on first load.
    // https://github.com/auth0/lock/issues/1942
    _defineProperty(_this, "onImageLoad", function () {
      return document.querySelector('.auth0-lock').style.fontSize = '1rem';
    });
    return _this;
  }
  _inherits(Welcome, _React$Component2);
  return _createClass(Welcome, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        name = _this$props2.name,
        imageUrl = _this$props2.imageUrl,
        title = _this$props2.title;
      var imgClassName = !!title ? 'auth0-lock-header-logo' : 'auth0-lock-header-logo centered';
      var img = /*#__PURE__*/_react.default.createElement("img", {
        alt: "",
        className: imgClassName,
        src: imageUrl,
        onLoad: this.onImageLoad
      });
      var welcome = title ? /*#__PURE__*/_react.default.createElement(WelcomeMessage, {
        title: title,
        name: name
      }) : null;
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-header-welcome"
      }, imageUrl && img, welcome);
    }
  }]);
}(_react.default.Component);
Welcome.propTypes = {
  imageUrl: _propTypes.default.string,
  name: _propTypes.default.string
};
var WelcomeMessage = /*#__PURE__*/function (_React$Component3) {
  function WelcomeMessage() {
    _classCallCheck(this, WelcomeMessage);
    return _callSuper(this, WelcomeMessage, arguments);
  }
  _inherits(WelcomeMessage, _React$Component3);
  return _createClass(WelcomeMessage, [{
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
        name = _this$props3.name,
        title = _this$props3.title;
      var className, message;
      if (name) {
        className = 'auth0-lock-firstname';
        message = name;
      } else {
        className = 'auth0-lock-name';
        message = title;
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        className: className,
        title: message,
        role: "heading",
        "aria-level": "1"
      }, message);
    }
  }]);
}(_react.default.Component);
WelcomeMessage.propTypes = {
  name: _propTypes.default.string
};
var cssBlurSupport = function () {
  if (typeof window === 'undefined') {
    return;
  }

  // Check stolen from Modernizr, see https://github.com/Modernizr/Modernizr/blob/29eab707f7a2fb261c8a9c538370e97eb1f86e25/feature-detects/css/filters.js
  var isEdge = window.navigator && !!window.navigator.userAgent.match(/Edge/i);
  if (typeof window.document === 'undefined' || isEdge) return false;
  var el = window.document.createElement('div');
  el.style.cssText = 'filter: blur(2px); -webkit-filter: blur(2px)';
  return !!el.style.length && (window.document.documentMode === undefined || window.document.documentMode > 9);
}();
var Background = /*#__PURE__*/function (_React$Component4) {
  function Background() {
    _classCallCheck(this, Background);
    return _callSuper(this, Background, arguments);
  }
  _inherits(Background, _React$Component4);
  return _createClass(Background, [{
    key: "render",
    value: function render() {
      var _this$props4 = this.props,
        backgroundColor = _this$props4.backgroundColor,
        imageUrl = _this$props4.imageUrl,
        grayScale = _this$props4.grayScale;
      var props = {
        className: 'auth0-lock-header-bg'
      };
      if (cssBlurSupport) {
        props.className += ' auth0-lock-blur-support';
      }
      var blurProps = {
        className: 'auth0-lock-header-bg-blur',
        style: {
          backgroundImage: "url('".concat(imageUrl, "')")
        }
      };
      if (grayScale) {
        blurProps.className += ' auth0-lock-no-grayscale';
      }
      var solidProps = {
        className: 'auth0-lock-header-bg-solid',
        style: {
          backgroundColor: backgroundColor
        }
      };
      return /*#__PURE__*/_react.default.createElement("div", props, /*#__PURE__*/_react.default.createElement("div", blurProps), /*#__PURE__*/_react.default.createElement("div", solidProps));
    }
  }]);
}(_react.default.Component);
Background.propTypes = {
  backgorundColor: _propTypes.default.string,
  grayScale: _propTypes.default.bool,
  imageUrl: _propTypes.default.string
};
