"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultProps = exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _chrome = _interopRequireDefault(require("./chrome"));
var _button = require("./button");
var l = _interopRequireWildcard(require("../../core/index"));
var c = _interopRequireWildcard(require("../../field/index"));
var _index3 = require("../../store/index");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var badgeSvg = /*#__PURE__*/_react.default.createElement("svg", {
  focusable: "false",
  width: "58px",
  height: "21px",
  viewBox: "0 0 462 168"
}, /*#__PURE__*/_react.default.createElement("g", {
  id: "Page-1",
  stroke: "none",
  strokeWidth: "1",
  fill: "none",
  fillRule: "evenodd"
}, /*#__PURE__*/_react.default.createElement("g", {
  id: "logo-grey-horizontal"
}, /*#__PURE__*/_react.default.createElement("g", {
  id: "Group"
}, /*#__PURE__*/_react.default.createElement("g", {
  id: "LogoText",
  transform: "translate(188.000000, 41.500000)",
  fill: "#D0D2D3"
}, /*#__PURE__*/_react.default.createElement("path", {
  d: "M246.517,0.11 C238.439,0.11 231.607,3.916 226.759,11.115 C221.94,18.271 219.393,28.26 219.393,40 C219.393,51.74 221.94,61.729 226.759,68.884 C231.607,76.084 238.439,79.889 246.517,79.889 C254.595,79.889 261.427,76.084 266.275,68.884 C271.093,61.729 273.64,51.74 273.64,40 C273.64,28.26 271.093,18.271 266.275,11.115 C261.427,3.916 254.595,0.11 246.517,0.11 L246.517,0.11 Z M246.517,70.005 C242.655,70.005 239.604,67.82 237.187,63.324 C234.268,57.893 232.66,49.61 232.66,40 C232.66,30.39 234.268,22.106 237.187,16.676 C239.604,12.18 242.655,9.994 246.517,9.994 C250.378,9.994 253.43,12.18 255.847,16.676 C258.766,22.106 260.373,30.389 260.373,40 C260.373,49.611 258.766,57.895 255.847,63.324 C253.43,67.82 250.378,70.005 246.517,70.005 L246.517,70.005 Z M71.45,29.172 L71.45,63.484 C71.45,72.53 78.81,79.889 87.856,79.889 C95.746,79.889 101.707,75.975 103.902,74.291 C104.024,74.197 104.184,74.169 104.331,74.216 C104.478,74.263 104.592,74.379 104.637,74.527 L105.961,78.86 L115.737,78.86 L115.737,29.172 L103.175,29.172 L103.175,66.326 C103.175,66.501 103.076,66.662 102.921,66.743 C100.559,67.961 95.899,70.006 91.231,70.006 C87.252,70.006 84.012,66.768 84.012,62.787 L84.012,29.172 L71.45,29.172 L71.45,29.172 Z M197.237,78.859 L209.8,78.859 L209.8,44.547 C209.8,35.501 202.44,28.141 193.394,28.141 C186.735,28.141 181.393,31.004 178.802,32.71 C178.657,32.805 178.473,32.813 178.322,32.731 C178.171,32.649 178.075,32.491 178.075,32.318 L178.075,1.141 L165.513,1.141 L165.513,78.859 L178.075,78.859 L178.075,41.704 C178.075,41.529 178.174,41.368 178.33,41.288 C180.691,40.069 185.352,38.025 190.019,38.025 C191.947,38.025 193.76,38.776 195.123,40.139 C196.486,41.502 197.236,43.316 197.236,45.243 L197.236,78.859 L197.237,78.859 Z M124.792,39.055 L132.438,39.055 C132.697,39.055 132.907,39.265 132.907,39.524 L132.907,66.858 C132.907,74.043 138.753,79.888 145.938,79.888 C148.543,79.888 151.113,79.512 153.585,78.77 L153.585,69.796 C152.143,69.923 150.485,70.005 149.313,70.005 C147.193,70.005 145.469,68.28 145.469,66.161 L145.469,39.523 C145.469,39.264 145.679,39.054 145.938,39.054 L153.585,39.054 L153.585,29.171 L145.938,29.171 C145.679,29.171 145.469,28.961 145.469,28.702 L145.469,12.295 L132.907,12.295 L132.907,28.702 C132.907,28.961 132.697,29.171 132.438,29.171 L124.792,29.171 L124.792,39.055 L124.792,39.055 Z M51.361,78.859 L64.429,78.859 L44.555,9.55 C42.962,3.992 37.811,0.11 32.029,0.11 C26.247,0.11 21.096,3.992 19.502,9.55 L-0.372,78.859 L12.697,78.859 L18.449,58.798 C18.507,58.597 18.691,58.459 18.9,58.459 L45.158,58.459 C45.367,58.459 45.552,58.597 45.609,58.798 L51.361,78.859 L51.361,78.859 Z M42.056,48.576 L22.004,48.576 C21.857,48.576 21.718,48.507 21.629,48.388 C21.541,48.272 21.513,48.119 21.553,47.978 L31.579,13.012 C31.637,12.811 31.821,12.673 32.03,12.673 C32.239,12.673 32.423,12.811 32.48,13.012 L42.507,47.978 C42.547,48.12 42.519,48.272 42.43,48.388 C42.342,48.507 42.203,48.576 42.056,48.576 L42.056,48.576 Z",
  id: "Shape"
})), /*#__PURE__*/_react.default.createElement("g", {
  id: "LogoBadge",
  fillOpacity: "0.4",
  fill: "#FFFFFF"
}, /*#__PURE__*/_react.default.createElement("path", {
  d: "M119.555,135.861 L102.705,83.997 L146.813,51.952 L92.291,51.952 L75.44,0.09 L75.435,0.076 L129.965,0.076 L146.82,51.947 L146.821,51.946 L146.835,51.938 C156.623,82.03 146.542,116.256 119.555,135.861 L119.555,135.861 Z M31.321,135.861 L31.307,135.871 L75.426,167.924 L119.555,135.862 L75.44,103.808 L31.321,135.861 L31.321,135.861 Z M4.052,51.939 L4.052,51.939 C-6.252,83.66 5.709,117.272 31.312,135.867 L31.316,135.851 L48.168,83.99 L4.07,51.951 L58.579,51.951 L75.431,0.089 L75.435,0.075 L20.902,0.075 L4.052,51.939 L4.052,51.939 Z",
  id: "Shape"
}))))));
var BottomBadge = function BottomBadge(_ref) {
  var link = _ref.link;
  return /*#__PURE__*/_react.default.createElement("span", {
    className: "auth0-lock-badge-bottom"
  }, /*#__PURE__*/_react.default.createElement("a", {
    href: link,
    target: "_blank",
    className: "auth0-lock-badge",
    rel: "noopener noreferrer"
  }, "Protected with ", badgeSvg));
};
var Avatar = function Avatar(_ref2) {
  var imageUrl = _ref2.imageUrl;
  return /*#__PURE__*/_react.default.createElement("img", {
    src: imageUrl,
    className: "auth0-lock-header-avatar"
  });
};
Avatar.propTypes = {
  imageUrl: _propTypes.default.string.isRequired
};
var EscKeyDownHandler = /*#__PURE__*/function () {
  function EscKeyDownHandler(f) {
    _classCallCheck(this, EscKeyDownHandler);
    this.handler = function (e) {
      if (e.keyCode == 27 && e.target.tagName.toUpperCase() != 'INPUT') {
        f();
      }
    };
    window.document.addEventListener('keydown', this.handler, false);
  }
  return _createClass(EscKeyDownHandler, [{
    key: "release",
    value: function release() {
      window.document.removeEventListener('keydown', this.handler);
    }
  }]);
}();
var IPHONE = typeof window !== 'undefined' && window.navigator && !!window.navigator.userAgent.match(/iPhone/i);
var Container = exports.default = /*#__PURE__*/function (_React$Component) {
  function Container(props) {
    var _this;
    _classCallCheck(this, Container);
    _this = _callSuper(this, Container, [props]);
    _this.state = {
      isOpen: false
    };
    return _this;
  }
  _inherits(Container, _React$Component);
  return _createClass(Container, [{
    key: "checkConnectionResolver",
    value: function checkConnectionResolver(done) {
      var contentProps = this.props.contentProps;
      var lock = contentProps.model;
      var connectionResolver = l.connectionResolver(lock);
      if (!connectionResolver) {
        return done();
      }
      var _lock$get$toJS = lock.get('client').toJS(),
        connections = _lock$get$toJS.connections,
        id = _lock$get$toJS.id;
      var context = {
        connections: connections,
        id: id
      };
      var userInputValue = c.getFieldValue(lock, 'username') || c.getFieldValue(lock, 'email');
      connectionResolver(userInputValue, context, function (resolvedConnection) {
        (0, _index3.swap)(_index3.updateEntity, 'lock', l.id(lock), function (m) {
          return l.setResolvedConnection(m, resolvedConnection);
        });
        done();
      });
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;
      if (this.props.isModal) {
        setTimeout(function () {
          return _this2.setState({
            isOpen: true
          });
        }, 17);
      }
      if (this.props.closeHandler) {
        this.escKeydown = new EscKeyDownHandler(this.handleEsc.bind(this));
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.escKeydown) {
        this.escKeydown.release();
      }
    }
  }, {
    key: "handleSubmit",
    value: function handleSubmit(e) {
      var _this3 = this;
      e.preventDefault();
      // Safari does not disable form submits when the submit button is disabled
      // on single input (eg. passwordless) forms, so disable it manually.
      if (this.props.isSubmitting) {
        return;
      }
      this.checkConnectionResolver(function () {
        var submitHandler = _this3.props.submitHandler;
        if (submitHandler) {
          setTimeout(function () {
            if (!_this3.props.isSubmitting) {
              _this3.refs.chrome.focusError();
            }
          }, 17);
          submitHandler();
        }
      });
    }
  }, {
    key: "handleClose",
    value: function handleClose() {
      var _this$props = this.props,
        closeHandler = _this$props.closeHandler,
        isSubmitting = _this$props.isSubmitting;
      if (!isSubmitting) {
        closeHandler();
      }
    }
  }, {
    key: "handleEsc",
    value: function handleEsc() {
      var _this$props2 = this.props,
        closeHandler = _this$props2.closeHandler,
        escHandler = _this$props2.escHandler;
      escHandler ? escHandler() : this.handleClose();
    }
  }, {
    key: "hide",
    value: function hide() {
      this.setState({
        isOpen: false
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
        autofocus = _this$props3.autofocus,
        avatar = _this$props3.avatar,
        auxiliaryPane = _this$props3.auxiliaryPane,
        backHandler = _this$props3.backHandler,
        badgeLink = _this$props3.badgeLink,
        closeHandler = _this$props3.closeHandler,
        contentComponent = _this$props3.contentComponent,
        contentProps = _this$props3.contentProps,
        disableSubmitButton = _this$props3.disableSubmitButton,
        disallowClose = _this$props3.disallowClose,
        error = _this$props3.error,
        info = _this$props3.info,
        isMobile = _this$props3.isMobile,
        isModal = _this$props3.isModal,
        isSubmitting = _this$props3.isSubmitting,
        logo = _this$props3.logo,
        primaryColor = _this$props3.primaryColor,
        screenName = _this$props3.screenName,
        showBadge = _this$props3.showBadge,
        submitButtonLabel = _this$props3.submitButtonLabel,
        submitHandler = _this$props3.submitHandler,
        success = _this$props3.success,
        tabs = _this$props3.tabs,
        terms = _this$props3.terms,
        title = _this$props3.title,
        classNames = _this$props3.classNames,
        scrollGlobalMessagesIntoView = _this$props3.scrollGlobalMessagesIntoView,
        suppressSubmitOverlay = _this$props3.suppressSubmitOverlay;
      var badge = showBadge ? /*#__PURE__*/_react.default.createElement(BottomBadge, {
        link: badgeLink
      }) : null;
      var overlay = isModal ? /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-overlay"
      }, badge) : null;
      var className = 'auth0-lock';
      if (isModal && this.state.isOpen) {
        className += ' auth0-lock-opened';
      }
      if (!isModal) {
        className += ' auth0-lock-opened-in-frame';
      }
      if (isMobile) {
        className += ' auth0-lock-mobile';
      }
      if (isSubmitting && !suppressSubmitOverlay) {
        className += ' auth0-lock-mode-loading';
      }
      if (auxiliaryPane) {
        className += ' auth0-lock-auxiliary';
      }
      if (!submitHandler) {
        className += ' auth0-lock-no-submit';
      }
      if (terms) {
        className += ' auth0-lock-with-terms';
      }
      if (IPHONE) {
        className += ' auth0-lock-iphone';
      }

      // TODO: this no longer makes sense, instead of taking a tabs
      // prop we should take extra class names.
      if (tabs) {
        className += ' auth0-lock-with-tabs';
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        className: className,
        lang: this.props.language
      }, overlay, /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-center"
      }, /*#__PURE__*/_react.default.createElement("form", {
        className: "auth0-lock-widget",
        method: "post",
        noValidate: true,
        onSubmit: this.handleSubmit.bind(this)
      }, avatar && /*#__PURE__*/_react.default.createElement(Avatar, {
        imageUrl: avatar
      }), closeHandler && /*#__PURE__*/_react.default.createElement(_button.CloseButton, {
        onClick: this.handleClose.bind(this)
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-widget-container"
      }, /*#__PURE__*/_react.default.createElement(_chrome.default, {
        autofocus: autofocus,
        avatar: avatar,
        auxiliaryPane: auxiliaryPane,
        backHandler: backHandler,
        contentComponent: contentComponent,
        contentProps: contentProps,
        disableSubmitButton: disableSubmitButton,
        error: error,
        info: info,
        isSubmitting: isSubmitting,
        logo: logo,
        screenName: screenName,
        primaryColor: primaryColor,
        ref: "chrome",
        showSubmitButton: !!submitHandler,
        submitButtonLabel: submitButtonLabel,
        success: success,
        tabs: tabs,
        terms: terms,
        title: title,
        classNames: classNames,
        scrollGlobalMessagesIntoView: scrollGlobalMessagesIntoView
      })))));
    }
  }]);
}(_react.default.Component);
Container.propTypes = {
  autofocus: _propTypes.default.bool.isRequired,
  avatar: _propTypes.default.string,
  auxiliaryPane: _propTypes.default.element,
  backHandler: _propTypes.default.func,
  badgeLink: _propTypes.default.string.isRequired,
  closeHandler: _propTypes.default.func,
  contentComponent: _propTypes.default.func.isRequired,
  // TODO: it also can be a class component
  contentProps: _propTypes.default.object.isRequired,
  disableSubmitButton: _propTypes.default.bool.isRequired,
  error: _propTypes.default.node,
  info: _propTypes.default.node,
  isMobile: _propTypes.default.bool.isRequired,
  isModal: _propTypes.default.bool.isRequired,
  isSubmitting: _propTypes.default.bool.isRequired,
  language: _propTypes.default.string,
  logo: _propTypes.default.string.isRequired,
  primaryColor: _propTypes.default.string.isRequired,
  screenName: _propTypes.default.string.isRequired,
  showBadge: _propTypes.default.bool.isRequired,
  submitButtonLabel: _propTypes.default.string,
  success: _propTypes.default.node,
  tabs: _propTypes.default.bool,
  terms: _propTypes.default.element,
  title: _propTypes.default.string,
  classNames: _propTypes.default.string.isRequired,
  scrollGlobalMessagesIntoView: _propTypes.default.bool,
  suppressSubmitOverlay: _propTypes.default.bool
  // escHandler
  // submitHandler,
};

// NOTE: detecting the file protocol is important for things like electron.
var isFileProtocol = typeof window !== 'undefined' && window.window && window.location && window.location.protocol === 'file:';
var defaultProps = exports.defaultProps = Container.defaultProps = {
  autofocus: false,
  badgeLink: 'https://auth0.com/',
  contentProps: {},
  disableSubmitButton: false,
  isMobile: false,
  isSubmitting: false,
  language: 'en',
  logo: "".concat(isFileProtocol ? 'https:' : '', "//cdn.auth0.com/styleguide/components/1.0.8/media/logos/img/badge.png"),
  primaryColor: '#ea5323',
  showBadge: true,
  scrollGlobalMessagesIntoView: true
};
