"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _dompurify = require("dompurify");
var _reactTransitionGroup = require("react-transition-group");
var _multisize_slide = _interopRequireDefault(require("./multisize_slide"));
var _global_message = _interopRequireDefault(require("./global_message"));
var l = _interopRequireWildcard(require("../../core/index"));
var _header = _interopRequireDefault(require("./header"));
var _classnames = _interopRequireDefault(require("classnames"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
var SubmitSvg = function SubmitSvg() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    "aria-hidden": "true",
    focusable: "false",
    width: "43px",
    height: "42px",
    viewBox: "0 0 43 42",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg",
    xmlnsXlink: "http://www.w3.org/1999/xlink"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "Page-1",
    stroke: "none",
    strokeWidth: "1",
    fill: "none",
    fillRule: "evenodd"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "Lock",
    transform: "translate(-280.000000, -3592.000000)"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "SMS",
    transform: "translate(153.000000, 3207.000000)"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "Group"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "Login",
    transform: "translate(0.000000, 369.000000)"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "Btn"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "Oval-302-+-Shape",
    transform: "translate(128.000000, 17.000000)"
  }, /*#__PURE__*/_react.default.createElement("circle", {
    id: "Oval-302",
    stroke: "#FFFFFF",
    strokeWidth: "2",
    cx: "20.5",
    cy: "20",
    r: "20"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M17.8,15.4 L19.2,14 L25.2,20 L19.2,26 L17.8,24.6 L22.4,20 L17.8,15.4 Z",
    id: "Shape",
    fill: "#FFFFFF"
  })))))))));
};
var SubmitTextSvg = function SubmitTextSvg() {
  return /*#__PURE__*/_react.default.createElement("svg", {
    "aria-hidden": "true",
    focusable: "false",
    className: "icon-text",
    width: "8px",
    height: "12px",
    viewBox: "0 0 8 12",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "Symbols",
    stroke: "none",
    strokeWidth: "1",
    fill: "none",
    fillRule: "evenodd"
  }, /*#__PURE__*/_react.default.createElement("g", {
    id: "Web/Submit/Active",
    transform: "translate(-148.000000, -32.000000)",
    fill: "#FFFFFF"
  }, /*#__PURE__*/_react.default.createElement("polygon", {
    id: "Shape",
    points: "148 33.4 149.4 32 155.4 38 149.4 44 148 42.6 152.6 38"
  }))));
};
var SubmitButton = /*#__PURE__*/function (_React$Component) {
  function SubmitButton() {
    _classCallCheck(this, SubmitButton);
    return _callSuper(this, SubmitButton, arguments);
  }
  _inherits(SubmitButton, _React$Component);
  return _createClass(SubmitButton, [{
    key: "handleSubmit",
    value: function handleSubmit() {
      var _this$props = this.props,
        label = _this$props.label,
        screenName = _this$props.screenName,
        contentProps = _this$props.contentProps;
      var model = contentProps.model;
      if (screenName === 'main.signUp') {
        l.emitEvent(model, 'signup submit');
      } else if (screenName === 'main.login') {
        l.emitEvent(model, 'signin submit');
      } else if (screenName === 'forgotPassword') {
        l.emitEvent(model, 'forgot_password submit');
      } else if (screenName === 'socialOrEmail') {
        l.emitEvent(model, 'socialOrEmail submit');
      } else if (screenName === 'socialOrPhoneNumber') {
        l.emitEvent(model, 'socialOrPhoneNumber submit');
      } else if (screenName === 'vcode') {}
      if (this.props.onSubmit) {
        this.props.onSubmit(label, screenName);
      }
    }
  }, {
    key: "focus",
    value: function focus() {
      _reactDom.default.findDOMNode(this).focus();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        color = _this$props2.color,
        disabled = _this$props2.disabled,
        label = _this$props2.label,
        display = _this$props2.display,
        contentProps = _this$props2.contentProps;
      var model = contentProps.model;
      var content = label ? /*#__PURE__*/_react.default.createElement("span", {
        className: "auth0-label-submit"
      }, label, /*#__PURE__*/_react.default.createElement(SubmitTextSvg, null)) : /*#__PURE__*/_react.default.createElement(SubmitSvg, null);
      return /*#__PURE__*/_react.default.createElement("button", {
        id: "".concat(l.id(model), "-submit"),
        className: "auth0-lock-submit",
        disabled: disabled,
        style: {
          backgroundColor: color,
          display: display
        },
        onClick: this.handleSubmit.bind(this),
        name: "submit",
        type: "submit",
        "aria-label": label ? label : 'Submit'
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-loading-container"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-loading"
      })), content);
    }
  }]);
}(_react.default.Component);
SubmitButton.propTypes = {
  color: _propTypes.default.string.isRequired,
  disabled: _propTypes.default.bool,
  display: _propTypes.default.string,
  label: _propTypes.default.string,
  screenName: _propTypes.default.string,
  onSubmit: _propTypes.default.func,
  contentProps: _propTypes.default.object
};
var MESSAGE_ANIMATION_DURATION = 250;
var AUXILIARY_ANIMATION_DURATION = 350;
var Chrome = exports.default = /*#__PURE__*/function (_React$Component2) {
  function Chrome(props) {
    var _this;
    _classCallCheck(this, Chrome);
    _this = _callSuper(this, Chrome, [props]);
    _this.state = {
      moving: false,
      reverse: false,
      headerHeight: 0
    };
    return _this;
  }

  // eslint-disable-next-line react/no-deprecated
  _inherits(Chrome, _React$Component2);
  return _createClass(Chrome, [{
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      var _this2 = this;
      var _this$props3 = this.props,
        auxiliaryPane = _this$props3.auxiliaryPane,
        showSubmitButton = _this$props3.showSubmitButton;
      var delayingShowSubmitButton = this.state.delayingShowSubmitButton;
      if (!showSubmitButton && nextProps.showSubmitButton && !delayingShowSubmitButton) {
        this.setState({
          delayingShowSubmitButton: true
        });
      }
      if (!auxiliaryPane && nextProps.auxiliaryPane) {
        this.auxiliaryPaneTriggerInput = window.document.activeElement;
        this.setState({
          moving: true
        });
      }
      if (auxiliaryPane && !nextProps.auxiliaryPane) {
        // TODO clear timeout
        setTimeout(function () {
          return _this2.setState({
            moving: false
          });
        }, AUXILIARY_ANIMATION_DURATION + 50);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this3 = this;
      var _this$props4 = this.props,
        autofocus = _this$props4.autofocus,
        auxiliaryPane = _this$props4.auxiliaryPane,
        error = _this$props4.error,
        screenName = _this$props4.screenName;
      if (!autofocus) return;
      if (auxiliaryPane && !prevProps.auxiliaryPane) {
        var input = this.findAutofocusInput(this.refs.auxiliary);
        if (input) {
          // TODO clear timeout
          setTimeout(function () {
            return input.focus();
          }, AUXILIARY_ANIMATION_DURATION);
        }
        return;
      }
      if (!auxiliaryPane && prevProps.auxiliaryPane) {
        if (this.auxiliaryPaneTriggerInput) {
          // TODO clear timeout
          setTimeout(function () {
            return _this3.auxiliaryPaneTriggerInput.focus();
          }, AUXILIARY_ANIMATION_DURATION);
        }
        return;
      }
      if (screenName !== prevProps.screenName) {
        var _input = this.findAutofocusInput();
        if (_input) {
          if (this.mainScreenName(prevProps.screenName) !== this.mainScreenName()) {
            this.inputToFocus = _input;
          } else {
            // TODO clear timeout
            setTimeout(function () {
              return _input.focus();
            }, 17);
          }
        }
      }
    }
  }, {
    key: "onWillSlide",
    value: function onWillSlide() {
      this.setState({
        moving: true
      });
      this.sliding = true;
    }
  }, {
    key: "onDidSlide",
    value: function onDidSlide() {
      this.sliding = false;
      this.setState({
        reverse: false
      });
    }
  }, {
    key: "onDidAppear",
    value: function onDidAppear() {
      this.setState({
        moving: false
      });
      if (this.state.delayingShowSubmitButton) {
        this.setState({
          delayingShowSubmitButton: false
        });
      }
      if (this.inputToFocus) {
        this.inputToFocus.focus();
        delete this.inputToFocus;
      }
    }
  }, {
    key: "mainScreenName",
    value: function mainScreenName(str) {
      return (str || this.props.screenName || '').split('.')[0];
    }
  }, {
    key: "findAutofocusInput",
    value: function findAutofocusInput(ref) {
      return _reactDom.default.findDOMNode(ref || this.refs.screen).querySelector('input');
    }
  }, {
    key: "focusError",
    value: function focusError() {
      var node = _reactDom.default.findDOMNode(this.refs.screen);
      // TODO: make the error input selector configurable via props.
      var error = node.querySelector('.auth0-lock-error input');
      if (error) {
        error.focus();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this4 = this;
      var _this$props5 = this.props,
        avatar = _this$props5.avatar,
        auxiliaryPane = _this$props5.auxiliaryPane,
        backHandler = _this$props5.backHandler,
        contentComponent = _this$props5.contentComponent,
        contentProps = _this$props5.contentProps,
        disableSubmitButton = _this$props5.disableSubmitButton,
        error = _this$props5.error,
        info = _this$props5.info,
        isSubmitting = _this$props5.isSubmitting,
        logo = _this$props5.logo,
        primaryColor = _this$props5.primaryColor,
        screenName = _this$props5.screenName,
        showSubmitButton = _this$props5.showSubmitButton,
        submitButtonLabel = _this$props5.submitButtonLabel,
        success = _this$props5.success,
        terms = _this$props5.terms,
        title = _this$props5.title,
        classNames = _this$props5.classNames,
        scrollGlobalMessagesIntoView = _this$props5.scrollGlobalMessagesIntoView;
      var model = contentProps.model;
      var _this$state = this.state,
        delayingShowSubmitButton = _this$state.delayingShowSubmitButton,
        moving = _this$state.moving,
        reverse = _this$state.reverse;
      var backgroundUrl, name;
      if (avatar) {
        backgroundUrl = avatar;
        name = title;
      } else {
        backgroundUrl = logo;
        name = '';
      }
      var shouldShowSubmitButton = showSubmitButton && !delayingShowSubmitButton;
      function wrapGlobalMessage(message) {
        return typeof message === 'string' ?
        /*#__PURE__*/
        // dangerouslySetInnerHTML input is sanitized using dompurify
        // eslint-disable-next-line react/no-danger
        _react.default.createElement('span', {
          dangerouslySetInnerHTML: {
            __html: (0, _dompurify.sanitize)(message)
          }
        }) : message;
      }
      var globalError = error ? /*#__PURE__*/_react.default.createElement(_global_message.default, {
        key: "global-error",
        message: wrapGlobalMessage(error),
        type: "error",
        scrollIntoView: scrollGlobalMessagesIntoView
      }) : null;
      var globalSuccess = success ? /*#__PURE__*/_react.default.createElement(_global_message.default, {
        key: "global-success",
        message: wrapGlobalMessage(success),
        type: "success",
        scrollIntoView: scrollGlobalMessagesIntoView
      }) : null;
      var globalInfo = info ? /*#__PURE__*/_react.default.createElement(_global_message.default, {
        key: "global-info",
        message: wrapGlobalMessage(info),
        type: "info",
        scrollIntoView: scrollGlobalMessagesIntoView
      }) : null;
      var Content = contentComponent;
      var isQuiet = !moving && !delayingShowSubmitButton;
      var className = (0, _classnames.default)('auth0-lock-cred-pane', {
        'auth0-lock-quiet': isQuiet,
        'auth0-lock-moving': !isQuiet
      });
      var internalWrapperClass = (0, _classnames.default)('auth0-lock-cred-pane-internal-wrapper', {
        'auto-height': l.ui.forceAutoHeight(model)
      });
      return /*#__PURE__*/_react.default.createElement("div", {
        className: className
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: internalWrapperClass
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-content-wrapper"
      }, /*#__PURE__*/_react.default.createElement(_header.default, {
        title: title,
        name: name,
        backHandler: backHandler && this.handleBack.bind(this),
        backgroundUrl: backgroundUrl,
        backgroundColor: primaryColor,
        logoUrl: logo
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-content-body-wrapper",
        style: {
          marginTop: this.state.headerHeight
        }
      }, /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.TransitionGroup, null, /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, {
        classNames: "global-message",
        timeout: MESSAGE_ANIMATION_DURATION
      }, /*#__PURE__*/_react.default.createElement("div", null, globalSuccess, globalError, globalInfo))), /*#__PURE__*/_react.default.createElement("div", {
        style: {
          position: 'relative'
        },
        ref: "screen"
      }, /*#__PURE__*/_react.default.createElement(_multisize_slide.default, {
        delay: 550,
        onDidAppear: this.onDidAppear.bind(this),
        onDidSlide: this.onDidSlide.bind(this),
        onWillSlide: this.onWillSlide.bind(this),
        transitionName: classNames,
        reverse: reverse
      }, /*#__PURE__*/_react.default.createElement("div", {
        key: this.mainScreenName(),
        className: "auth0-lock-view-content"
      }, /*#__PURE__*/_react.default.createElement("div", {
        style: {
          position: 'relative'
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-body-content"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-content"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-form"
      }, /*#__PURE__*/_react.default.createElement(Content, _extends({
        focusSubmit: this.focusSubmit.bind(this)
      }, contentProps)))), terms && /*#__PURE__*/_react.default.createElement("small", {
        className: "auth0-lock-terms"
      }, terms)))))))), /*#__PURE__*/_react.default.createElement(SubmitButton, {
        color: primaryColor,
        disabled: disableSubmitButton,
        screenName: screenName,
        contentProps: contentProps,
        label: submitButtonLabel,
        ref: function ref(el) {
          return _this4.submitButton = el;
        },
        display: shouldShowSubmitButton ? 'block' : 'none'
      }), auxiliaryPane && /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.TransitionGroup, null, /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, {
        ref: "auxiliary",
        classNames: "slide",
        timeout: AUXILIARY_ANIMATION_DURATION
      }, auxiliaryPane))));
    }
  }, {
    key: "focusSubmit",
    value: function focusSubmit() {
      this.submitButton.focus();
    }
  }, {
    key: "handleBack",
    value: function handleBack() {
      if (this.sliding) return;
      var backHandler = this.props.backHandler;
      this.setState({
        reverse: true
      });
      backHandler();
    }
  }]);
}(_react.default.Component);
Chrome.propTypes = {
  autofocus: _propTypes.default.bool.isRequired,
  avatar: _propTypes.default.string,
  auxiliaryPane: _propTypes.default.element,
  backHandler: _propTypes.default.func,
  contentComponent: _propTypes.default.func.isRequired,
  // TODO: it also can be a class component
  contentProps: _propTypes.default.object.isRequired,
  disableSubmitButton: _propTypes.default.bool.isRequired,
  error: _propTypes.default.node,
  info: _propTypes.default.node,
  isSubmitting: _propTypes.default.bool.isRequired,
  logo: _propTypes.default.string.isRequired,
  primaryColor: _propTypes.default.string.isRequired,
  screenName: _propTypes.default.string.isRequired,
  showSubmitButton: _propTypes.default.bool.isRequired,
  submitButtonLabel: _propTypes.default.string,
  success: _propTypes.default.node,
  terms: _propTypes.default.element,
  title: _propTypes.default.string,
  classNames: _propTypes.default.string.isRequired,
  scrollGlobalMessagesIntoView: _propTypes.default.bool
};
Chrome.defaultProps = {
  autofocus: false,
  disableSubmitButton: false,
  showSubmitButton: true,
  scrollGlobalMessagesIntoView: true
};
