"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.group = group;
exports.html = html;
exports.initI18n = initI18n;
exports.str = str;
var _react = _interopRequireDefault(require("react"));
var _immutable = _interopRequireWildcard(require("immutable"));
var _format = _interopRequireDefault(require("./utils/format"));
var _dompurify = require("dompurify");
var _sync = _interopRequireDefault(require("./sync"));
var l = _interopRequireWildcard(require("./core/index"));
var _data_utils = require("./utils/data_utils");
var _en = _interopRequireDefault(require("./i18n/en"));
var _cdn_utils = require("./utils/cdn_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _dataFns = (0, _data_utils.dataFns)(['i18n']),
  get = _dataFns.get,
  set = _dataFns.set;
function str(m, keyPath) {
  for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    args[_key - 2] = arguments[_key];
  }
  return _format.default.apply(void 0, [get(m, ['strings'].concat(keyPath), '')].concat(args));
}
function html(m, keyPath) {
  for (var _len2 = arguments.length, args = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
    args[_key2 - 2] = arguments[_key2];
  }
  var html = str.apply(void 0, [m, keyPath].concat(args));
  // dangerouslySetInnerHTML input is sanitized using dompurify
  // eslint-disable-next-line react/no-danger
  return html ? /*#__PURE__*/_react.default.createElement('span', {
    dangerouslySetInnerHTML: {
      __html: (0, _dompurify.sanitize)(html)
    }
  }) : null;
}
function group(m, keyPath) {
  return get(m, ['strings'].concat(keyPath), (0, _immutable.Map)()).toJS();
}
function initI18n(m) {
  var language = l.ui.language(m);
  var overrides = l.ui.dict(m);
  var defaultDictionary = _immutable.default.fromJS(_en.default);
  var base = languageDictionaries[language] || (0, _immutable.Map)({});
  if (base.isEmpty()) {
    base = overrides;
    m = (0, _sync.default)(m, 'i18n', {
      syncFn: function syncFn(_, cb) {
        return syncLang(m, language, cb);
      },
      successFn: function successFn(m, result) {
        registerLanguageDictionary(language, result);
        var overrided = _immutable.default.fromJS(result).mergeDeep(overrides);
        assertLanguage(m, overrided.toJS(), _en.default);
        return set(m, 'strings', defaultDictionary.mergeDeep(overrided));
      },
      recoverResult: m,
      errorFn: function errorFn(m, error) {
        l.warn(m, error.message + ' Falling back to default dictionary.');
      }
    });
  } else {
    assertLanguage(m, base.toJS(), _en.default);
  }
  base = defaultDictionary.mergeDeep(base).mergeDeep(overrides);
  return set(m, 'strings', base);
}
function assertLanguage(m, language, base) {
  var path = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
  Object.keys(base).forEach(function (key) {
    if (!language.hasOwnProperty(key)) {
      l.warn(m, "language does not have property ".concat(path).concat(key));
    } else {
      if (_typeof(base[key]) === 'object') {
        assertLanguage(m, language[key], base[key], "".concat(path).concat(key, "."));
      }
    }
  });
}

// sync

function syncLang(m, language, _cb) {
  (0, _cdn_utils.load)({
    method: 'registerLanguageDictionary',
    url: "".concat(l.languageBaseUrl(m), "/js/lock/").concat("12.5.2", "/").concat(language, ".js"),
    check: function check(str) {
      return str && str === language;
    },
    cb: function cb(err, _, dictionary) {
      _cb(err, dictionary);
    }
  });
}
var languageDictionaries = [];
function registerLanguageDictionary(language, dictionary) {
  languageDictionaries[language] = _immutable.default.fromJS(dictionary);
}
if (typeof window !== 'undefined') {
  (0, _cdn_utils.preload)({
    method: 'registerLanguageDictionary',
    cb: registerLanguageDictionary
  });
}
