"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _auth_button = _interopRequireDefault(require("../../ui/button/auth_button"));
var l = _interopRequireWildcard(require("../../core/index"));
var _actions = require("../../quick-auth/actions");
var _index2 = require("../../connection/social/index");
var _event = require("./event");
var _index3 = require("../../connection/database/index");
var _actions2 = require("../../connection/database/actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
var SocialButtonsPane = exports.default = /*#__PURE__*/function (_React$Component) {
  function SocialButtonsPane() {
    _classCallCheck(this, SocialButtonsPane);
    return _callSuper(this, SocialButtonsPane, arguments);
  }
  _inherits(SocialButtonsPane, _React$Component);
  return _createClass(SocialButtonsPane, [{
    key: "handleSubmit",
    value: function handleSubmit(lock, provider, isSignUp) {
      if (isSignUp && !(0, _index3.termsAccepted)(lock)) {
        return (0, _actions2.signUpError)(lock.get('id'), {
          code: 'social_signup_needs_terms_acception'
        });
      }
      (0, _event.emitFederatedLoginEvent)(this.props.lock, provider, isSignUp);
      return (0, _actions.logIn)(l.id(this.props.lock), provider);
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;
      // TODO: i don't like that it receives the instructions tanslated
      // but it also takes the t fn
      var _this$props = this.props,
        instructions = _this$props.instructions,
        labelFn = _this$props.labelFn,
        lock = _this$props.lock,
        showLoading = _this$props.showLoading,
        signUp = _this$props.signUp;
      var headerText = instructions || null;
      var header = headerText && /*#__PURE__*/_react.default.createElement("p", null, headerText);
      var themes = (0, _index2.authButtonsTheme)(lock);
      var buttons = (0, _index2.socialConnections)(lock).map(function (x) {
        var buttonTheme = themes.get(x.get('name'));
        var connectionName = buttonTheme && buttonTheme.get('displayName');
        var primaryColor = buttonTheme && buttonTheme.get('primaryColor');
        var foregroundColor = buttonTheme && buttonTheme.get('foregroundColor');
        var icon = buttonTheme && buttonTheme.get('icon');
        return /*#__PURE__*/_react.default.createElement(_auth_button.default, {
          key: x.get('name'),
          label: labelFn(signUp ? 'signUpWithLabel' : 'loginWithLabel', connectionName || (0, _index2.displayName)(x)),
          onClick: function onClick() {
            return _this.handleSubmit(lock, x, signUp);
          },
          strategy: x.get('strategy'),
          primaryColor: primaryColor,
          foregroundColor: foregroundColor,
          icon: icon
        });
      });
      var loading = showLoading && /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-loading-container"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-loading"
      }));
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "auth-lock-social-buttons-pane"
      }, header, /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-social-buttons-container"
      }, buttons), loading);
    }
  }]);
}(_react.default.Component);
SocialButtonsPane.propTypes = {
  instructions: _propTypes.default.any,
  labelFn: _propTypes.default.func.isRequired,
  lock: _propTypes.default.object.isRequired,
  showLoading: _propTypes.default.bool.isRequired,
  signUp: _propTypes.default.bool.isRequired,
  e: _propTypes.default.bool
};
SocialButtonsPane.defaultProps = {
  showLoading: false,
  e: false
};
