"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isThirdPartyCaptcha = exports.ThirdPartyCaptcha = void 0;
var _createRef = require("../../utils/createRef");
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
var noop = function noop() {};
var RECAPTCHA_V2_PROVIDER = 'recaptcha_v2';
var RECAPTCHA_ENTERPRISE_PROVIDER = 'recaptcha_enterprise';
var HCAPTCHA_PROVIDER = 'hcaptcha';
var FRIENDLY_CAPTCHA_PROVIDER = 'friendly_captcha';
var ARKOSE_PROVIDER = 'arkose';
var AUTH0_V2_CAPTCHA_PROVIDER = 'auth0_v2';
var TIMEOUT_MS = 500;
var MAX_RETRY = 3;
var isThirdPartyCaptcha = exports.isThirdPartyCaptcha = function isThirdPartyCaptcha(provider) {
  return provider === RECAPTCHA_ENTERPRISE_PROVIDER || provider === RECAPTCHA_V2_PROVIDER || provider === HCAPTCHA_PROVIDER || provider === FRIENDLY_CAPTCHA_PROVIDER || provider === ARKOSE_PROVIDER || provider === AUTH0_V2_CAPTCHA_PROVIDER;
};
var getCaptchaProvider = function getCaptchaProvider(provider) {
  switch (provider) {
    case RECAPTCHA_V2_PROVIDER:
      return window.grecaptcha;
    case RECAPTCHA_ENTERPRISE_PROVIDER:
      return window.grecaptcha.enterprise;
    case HCAPTCHA_PROVIDER:
      return window.hcaptcha;
    case FRIENDLY_CAPTCHA_PROVIDER:
      return window.friendlyChallenge;
    case ARKOSE_PROVIDER:
      return window.arkose;
    case AUTH0_V2_CAPTCHA_PROVIDER:
      return window.turnstile;
  }
};
var scriptForProvider = function scriptForProvider(provider, lang, callback, clientSubdomain, siteKey) {
  switch (provider) {
    case RECAPTCHA_V2_PROVIDER:
      return "https://www.recaptcha.net/recaptcha/api.js?hl=".concat(lang, "&onload=").concat(callback);
    case RECAPTCHA_ENTERPRISE_PROVIDER:
      return "https://www.recaptcha.net/recaptcha/enterprise.js?render=explicit&hl=".concat(lang, "&onload=").concat(callback);
    case HCAPTCHA_PROVIDER:
      return "https://js.hcaptcha.com/1/api.js?hl=".concat(lang, "&onload=").concat(callback);
    case FRIENDLY_CAPTCHA_PROVIDER:
      return 'https://cdn.jsdelivr.net/npm/friendly-challenge@0.9.12/widget.min.js';
    case ARKOSE_PROVIDER:
      return 'https://' + clientSubdomain + '.arkoselabs.com/v2/' + siteKey + '/api.js';
    case AUTH0_V2_CAPTCHA_PROVIDER:
      return "https://challenges.cloudflare.com/turnstile/v0/api.js?render=explicit&onload=".concat(callback);
  }
};
var providerDomPrefix = function providerDomPrefix(provider) {
  switch (provider) {
    case RECAPTCHA_V2_PROVIDER:
      return 'recaptcha';
    case RECAPTCHA_ENTERPRISE_PROVIDER:
      return 'recaptcha';
    case HCAPTCHA_PROVIDER:
      return 'hcaptcha';
    case FRIENDLY_CAPTCHA_PROVIDER:
      return 'friendly-captcha';
    case ARKOSE_PROVIDER:
      return 'arkose';
    case AUTH0_V2_CAPTCHA_PROVIDER:
      return 'auth0-v2';
  }
};
var providerComponentId = function providerComponentId(provider) {
  if (provider === HCAPTCHA_PROVIDER) {
    return 'h-captcha';
  } else {
    return '';
  }
};
var loadScript = function loadScript(url, attributes) {
  var script = document.createElement('script');
  for (var attr in attributes) {
    if (attr.startsWith('data-')) {
      script.dataset[attr.replace('data-', '')] = attributes[attr];
    } else {
      script[attr] = attributes[attr];
    }
  }
  script.src = url;
  document.body.appendChild(script);
};
var removeScript = function removeScript(url) {
  var scripts = document.body.querySelectorAll('script[src="' + url + '"]');
  scripts.forEach(function (script) {
    script.remove();
  });
};
var ThirdPartyCaptcha = exports.ThirdPartyCaptcha = /*#__PURE__*/function (_React$Component) {
  function ThirdPartyCaptcha(props) {
    var _this;
    _classCallCheck(this, ThirdPartyCaptcha);
    _this = _callSuper(this, ThirdPartyCaptcha, [props]);
    _this.state = {
      retryCount: 0,
      scriptUrl: ''
    };
    //this version of react doesn't have React.createRef
    _this.ref = (0, _createRef.createRef)();
    _this.changeHandler = function (value) {
      _this.setState({
        value: value
      }, function () {
        _this.props.onChange(value);
      });
    };
    _this.expiredHandler = function () {
      var value = '';
      _this.setState({
        value: value
      }, function () {
        _this.props.onChange(value);
        _this.props.onExpired();
      });
    };
    _this.erroredHandler = function () {
      var value = '';
      _this.setState({
        value: value
      }, function () {
        _this.props.onChange(value);
        _this.props.onErrored();
      });
    };
    return _this;
  }
  _inherits(ThirdPartyCaptcha, _React$Component);
  return _createClass(ThirdPartyCaptcha, [{
    key: "getRenderParams",
    value: function getRenderParams() {
      var _this2 = this;
      if (this.props.provider === FRIENDLY_CAPTCHA_PROVIDER) {
        return {
          sitekey: this.props.sitekey,
          language: this.props.hl,
          doneCallback: this.changeHandler,
          errorCallback: this.erroredHandler
        };
      }
      var renderParams = {
        sitekey: this.props.sitekey,
        callback: this.changeHandler,
        'expired-callback': this.expiredHandler,
        'error-callback': this.erroredHandler
      };
      if (this.props.provider === AUTH0_V2_CAPTCHA_PROVIDER) {
        renderParams = _objectSpread(_objectSpread({}, renderParams), {}, {
          language: this.props.hl,
          theme: 'light',
          retry: 'never',
          'response-field': false,
          'error-callback': function errorCallback() {
            if (_this2.state.retryCount < MAX_RETRY) {
              getCaptchaProvider(_this2.props.provider).reset(_this2.widgetId);
              _this2.setState(function (prevState) {
                return {
                  retryCount: prevState.retryCount + 1
                };
              });
            } else {
              // similar implementation to ARKOSE_PROVIDER failOpen
              _this2.changeHandler('BYPASS_CAPTCHA');
            }
            return true;
          }
        });
      }
      return renderParams;
    }
  }, {
    key: "injectCaptchaScript",
    value: function injectCaptchaScript() {
      var _this3 = this;
      var callback = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : noop;
      var _this$props = this.props,
        provider = _this$props.provider,
        hl = _this$props.hl,
        clientSubdomain = _this$props.clientSubdomain,
        sitekey = _this$props.sitekey;
      var callbackName = "".concat(providerDomPrefix(provider), "Callback_").concat(Math.floor(Math.random() * 1000001));
      var scriptUrl = scriptForProvider(provider, hl, callbackName, clientSubdomain, sitekey);
      this.setState({
        scriptUrl: scriptUrl
      });
      var attributes = {
        async: true,
        defer: true
      };
      if (provider === ARKOSE_PROVIDER || provider === AUTH0_V2_CAPTCHA_PROVIDER) {
        attributes['data-callback'] = callbackName;
        attributes['onerror'] = function () {
          if (_this3.state.retryCount < MAX_RETRY) {
            removeScript(scriptUrl);
            loadScript(scriptUrl, attributes);
            _this3.setState(function (prevState) {
              return {
                retryCount: prevState.retryCount + 1
              };
            });
            return;
          }
          removeScript(scriptUrl);
          _this3.changeHandler('BYPASS_CAPTCHA');
        };
        window[callbackName] = function (arkose) {
          callback(arkose);
        };
      } else {
        window[callbackName] = function () {
          delete window[callbackName];
          callback();
        };
        if (provider === FRIENDLY_CAPTCHA_PROVIDER) {
          attributes['onload'] = window[callbackName];
        }
      }
      loadScript(scriptUrl, attributes);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (!this.state.scriptUrl) {
        return;
      }
      removeScript(this.state.scriptUrl);
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this4 = this;
      this.injectCaptchaScript(function (arkose) {
        var provider = getCaptchaProvider(_this4.props.provider);
        if (_this4.props.provider === ARKOSE_PROVIDER) {
          arkose.setConfig({
            onReady: function onReady() {
              arkose.run();
            },
            onCompleted: function onCompleted(response) {
              _this4.changeHandler(response.token);
            },
            onError: function onError() {
              if (_this4.state.retryCount < MAX_RETRY) {
                arkose.reset();
                // To ensure reset is successful, we need to set a timeout here
                setTimeout(function () {
                  arkose.run();
                }, TIMEOUT_MS);
                _this4.setState(function (prevState) {
                  return {
                    retryCount: prevState.retryCount + 1
                  };
                });
              } else {
                _this4.changeHandler('BYPASS_CAPTCHA');
              }
            }
          });
        } else if (_this4.props.provider === FRIENDLY_CAPTCHA_PROVIDER) {
          _this4.widgetInstance = new provider.WidgetInstance(_this4.ref.current, _this4.getRenderParams());
        } else {
          // if this is enterprise then we change this to window.grecaptcha.enterprise.render
          _this4.widgetId = provider.render(_this4.ref.current, _this4.getRenderParams());
        }
      });
    }
  }, {
    key: "reset",
    value: function reset() {
      var provider = getCaptchaProvider(this.props.provider);
      if (this.props.provider === FRIENDLY_CAPTCHA_PROVIDER) {
        if (this.widgetInstance) {
          this.widgetInstance.reset();
        }
      } else {
        provider.reset(this.widgetId);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this5 = this;
      /*
        This is an override for the following conflicting css-rule:
         @media screen and (max-width: 480px)
        html.auth0-lock-html body > * {
            display: none;
        }
      */
      var fixInterval = setInterval(function () {
        var iframes = Array.from(document.querySelectorAll("iframe[src*=\"".concat(providerDomPrefix(_this5.props.provider), "\"]")));
        var containers = iframes.map(function (iframe) {
          return iframe.parentNode.parentNode;
        }).filter(function (container) {
          return container && container.parentNode === document.body && container.style.display !== 'block';
        });
        if (containers.length === 0) {
          return;
        }
        containers.forEach(function (iframe) {
          iframe.style.display = 'block';
        });
        clearInterval(fixInterval);
      }, 300);
      return /*#__PURE__*/_react.default.createElement("div", {
        className: this.props.isValid ? "auth0-lock-".concat(providerDomPrefix(this.props.provider), "-block") : "auth0-lock-".concat(providerDomPrefix(this.props.provider), "-block auth0-lock-").concat(providerDomPrefix(this.props.provider), "-block-error")
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "auth0-lock-".concat(providerDomPrefix(this.props.provider) === 'recaptcha' ? 'recaptchav2' : providerDomPrefix(this.props.provider)),
        id: providerComponentId(this.props.provider),
        ref: this.ref
      }));
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      var hCaptchaComponent = document.getElementById("h-captcha");
      if (prevProps.value !== this.props.value && this.props.value === '') {
        this.reset();
      }
      if (this.props.provider === HCAPTCHA_PROVIDER && hCaptchaComponent && window[this.props.provider]) {
        window[this.props.provider].render('h-captcha', this.getRenderParams());
      }
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (nextProps.value !== prevState.value) {
        return {
          value: nextProps.value
        };
      } else {
        return null;
      }
    }
  }]);
}(_react.default.Component); // TO DO: Confirm this change will not introduce unintended behavior for customers
ThirdPartyCaptcha.displayName = 'ThirdPartyCaptcha';
ThirdPartyCaptcha.propTypes = {
  provider: _propTypes.default.string.isRequired,
  sitekey: _propTypes.default.string.isRequired,
  clientSubdomain: _propTypes.default.string,
  onChange: _propTypes.default.func,
  onExpired: _propTypes.default.func,
  onErrored: _propTypes.default.func,
  hl: _propTypes.default.string,
  value: _propTypes.default.string,
  isValid: _propTypes.default.bool
};
ThirdPartyCaptcha.defaultProps = {
  onChange: noop,
  onExpired: noop,
  onErrored: noop
};
