"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _index = require("../store/index");
var _error_screen = _interopRequireDefault(require("../core/error_screen"));
var _loading_screen = _interopRequireDefault(require("../core/loading_screen"));
var _social_or_email_login_screen = _interopRequireDefault(require("./passwordless/social_or_email_login_screen"));
var _social_or_phone_number_login_screen = _interopRequireDefault(require("./passwordless/social_or_phone_number_login_screen"));
var _ask_vcode = _interopRequireDefault(require("../connection/passwordless/ask_vcode"));
var _last_login_screen = _interopRequireDefault(require("../core/sso/last_login_screen"));
var _index2 = require("../connection/passwordless/index");
var _sync = require("../sync");
var l = _interopRequireWildcard(require("../core/index"));
var _quick_auth = require("../quick_auth");
var sso = _interopRequireWildcard(require("../core/sso/index"));
var _email = require("../field/email");
var _phone_number = require("../field/phone_number");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var setPrefill = function setPrefill(m) {
  var _l$prefill$toJS = l.prefill(m).toJS(),
    email = _l$prefill$toJS.email,
    phoneNumber = _l$prefill$toJS.phoneNumber;
  if (typeof email === 'string') {
    m = (0, _email.setEmail)(m, email);
  }
  if (typeof phoneNumber === 'string') {
    m = (0, _phone_number.setPhoneNumber)(m, phoneNumber);
  }
  return m;
};
var Passwordless = /*#__PURE__*/function () {
  function Passwordless() {
    _classCallCheck(this, Passwordless);
  }
  return _createClass(Passwordless, [{
    key: "didInitialize",
    value: function didInitialize(m, opts) {
      m = (0, _index2.initPasswordless)(m, opts);
      return m;
    }
  }, {
    key: "didReceiveClientSettings",
    value: function didReceiveClientSettings(m) {
      var anySocialConnection = l.hasSomeConnections(m, 'social');
      var anyPasswordlessConnection = l.hasSomeConnections(m, 'passwordless');
      if (!anySocialConnection && !anyPasswordlessConnection) {
        var error = new Error('At least one email, sms or social connection needs to be available.');
        error.code = 'no_connection';
        m = l.stop(m, error);
      }
      m = setPrefill(m);
      return m;
    }
  }, {
    key: "render",
    value: function render(m) {
      //if there's an error, we should show the error screen no matter what.
      if (l.hasStopped(m)) {
        return new _error_screen.default();
      }

      // TODO: remove the detail about the loading pane being pinned,
      // sticky screens should be handled at the box module.
      if (!(0, _sync.isDone)(m) || m.get('isLoadingPanePinned')) {
        return new _loading_screen.default();
      }
      if (!(0, _quick_auth.hasSkippedQuickAuth)(m)) {
        if (l.ui.rememberLastLogin(m)) {
          var lastUsedConnection = sso.lastUsedConnection(m);
          var lastUsedUsername = sso.lastUsedUsername(m);
          if (lastUsedConnection && (0, _sync.isSuccess)(m, 'sso') && l.hasConnection(m, lastUsedConnection.get('name')) && ['passwordless', 'social'].indexOf(l.findConnection(m, lastUsedConnection.get('name')).get('type')) >= 0 //if connection.type is either passwordless or social
          ) {
            var conn = l.findConnection(m, lastUsedConnection.get('name'));
            var connectionType = conn.get('type');
            if (connectionType === 'passwordless' || connectionType === 'social') {
              return new _last_login_screen.default();
            }
          }
        }
      }
      if ((0, _index2.isEmail)(m)) {
        return (0, _index2.isSendLink)(m) || !(0, _index2.passwordlessStarted)(m) ? new _social_or_email_login_screen.default() : new _ask_vcode.default();
      } else {
        return (0, _index2.passwordlessStarted)(m) ? new _ask_vcode.default() : new _social_or_phone_number_login_screen.default();
      }
    }
  }]);
}();
var _default = exports.default = new Passwordless();
