"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _screen = _interopRequireDefault(require("../../core/screen"));
var _social_buttons_pane = _interopRequireDefault(require("../../field/social/social_buttons_pane"));
var _login_pane = _interopRequireDefault(require("../../connection/database/login_pane"));
var _pane_separator = _interopRequireDefault(require("../../core/pane_separator"));
var _index = require("../../connection/database/index");
var _actions = require("../../connection/database/actions");
var _signed_in_confirmation = require("../../core/signed_in_confirmation");
var _login_sign_up_tabs = _interopRequireDefault(require("../../connection/database/login_sign_up_tabs"));
var l = _interopRequireWildcard(require("../../core/index"));
var _actions2 = require("../../connection/enterprise/actions");
var _enterprise = require("../../connection/enterprise");
var _single_sign_on_notice = _interopRequireDefault(require("../../connection/enterprise/single_sign_on_notice"));
var _classic = require("../classic");
var i18n = _interopRequireWildcard(require("../../i18n"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function shouldRenderTabs(m) {
  if ((0, _classic.isSSOEnabled)(m)) return false;
  if (l.hasSomeConnections(m, 'database')) return (0, _index.hasScreen)(m, 'signUp');
  if (l.hasSomeConnections(m, 'social') && (0, _index.hasInitialScreen)(m, 'signUp')) return (0, _index.hasScreen)(m, 'signUp');
}
var LoginComponent = function LoginComponent(_ref) {
  var i18n = _ref.i18n,
    model = _ref.model;
  var sso = (0, _classic.isSSOEnabled)(model);
  var onlySocial = (0, _classic.hasOnlyClassicConnections)(model, 'social');
  var tabs = shouldRenderTabs(model) && /*#__PURE__*/_react.default.createElement(_login_sign_up_tabs.default, {
    key: "loginsignup",
    lock: model,
    loginLabel: i18n.str('loginLabel'),
    signUpLink: (0, _index.signUpLink)(model),
    signUpLabel: i18n.str('signUpLabel')
  });
  var social = l.hasSomeConnections(model, 'social') && /*#__PURE__*/_react.default.createElement(_social_buttons_pane.default, {
    instructions: i18n.html('socialLoginInstructions'),
    labelFn: i18n.str,
    lock: model,
    showLoading: onlySocial,
    signUp: false
  });
  var showPassword = !sso && (l.hasSomeConnections(model, 'database') || !!(0, _enterprise.findADConnectionWithoutDomain)(model));
  var showForgotPasswordLink = showPassword && l.hasSomeConnections(model, 'database');
  var loginInstructionsKey = social ? 'databaseEnterpriseAlternativeLoginInstructions' : 'databaseEnterpriseLoginInstructions';
  var usernameInputPlaceholderKey = (0, _index.databaseUsernameStyle)(model) === 'any' || l.countConnections(model, 'enterprise') > 1 ? 'usernameOrEmailInputPlaceholder' : 'usernameInputPlaceholder';
  var usernameStyle = (0, _index.databaseUsernameStyle)(model);
  var login = (sso || l.hasSomeConnections(model, 'database') || l.hasSomeConnections(model, 'enterprise')) && /*#__PURE__*/_react.default.createElement(_login_pane.default, {
    emailInputPlaceholder: i18n.str('emailInputPlaceholder'),
    forgotPasswordAction: i18n.str('forgotPasswordAction'),
    i18n: i18n,
    instructions: i18n.html(loginInstructionsKey),
    lock: model,
    passwordInputPlaceholder: i18n.str('passwordInputPlaceholder'),
    showForgotPasswordLink: showForgotPasswordLink,
    showPassword: showPassword,
    usernameInputPlaceholder: i18n.str(usernameInputPlaceholderKey),
    usernameStyle: usernameStyle
  });
  var ssoNotice = sso && /*#__PURE__*/_react.default.createElement(_single_sign_on_notice.default, null, i18n.str('ssoEnabled'));
  var separator = social && login && /*#__PURE__*/_react.default.createElement(_pane_separator.default, null);
  return /*#__PURE__*/_react.default.createElement("div", null, ssoNotice, tabs, /*#__PURE__*/_react.default.createElement("div", null, social, separator, login));
};
var Login = exports.default = /*#__PURE__*/function (_Screen) {
  function Login() {
    _classCallCheck(this, Login);
    return _callSuper(this, Login, ['main.login']);
  }
  _inherits(Login, _Screen);
  return _createClass(Login, [{
    key: "renderAuxiliaryPane",
    value: function renderAuxiliaryPane(lock) {
      return (0, _signed_in_confirmation.renderSignedInConfirmation)(lock);
    }
  }, {
    key: "renderTabs",
    value: function renderTabs(model) {
      return shouldRenderTabs(model);
    }
  }, {
    key: "submitButtonLabel",
    value: function submitButtonLabel(m) {
      return i18n.str(m, ['loginSubmitLabel']);
    }
  }, {
    key: "isSubmitDisabled",
    value: function isSubmitDisabled(m) {
      // it should disable the submit button if there is any connection that
      // requires username/password and there is no enterprise with domain
      // that matches with the email domain entered for HRD
      return !l.hasSomeConnections(m, 'database') &&
      // no database connection
      !(0, _enterprise.findADConnectionWithoutDomain)(m) &&
      // no enterprise without domain
      !(0, _classic.isSSOEnabled)(m); // no matching domain
    }
  }, {
    key: "submitHandler",
    value: function submitHandler(model) {
      if ((0, _classic.hasOnlyClassicConnections)(model, 'social')) {
        return null;
      }
      if ((0, _enterprise.isHRDDomain)(model, (0, _index.databaseUsernameValue)(model))) {
        return function (id) {
          return (0, _actions2.startHRD)(id, (0, _index.databaseUsernameValue)(model));
        };
      }
      var useDatabaseConnection = !(0, _classic.isSSOEnabled)(model) && (0, _index.databaseConnection)(model) && ((0, _index.defaultDatabaseConnection)(model) || !(0, _enterprise.defaultEnterpriseConnection)(model));
      return useDatabaseConnection ? _actions.logIn : _actions2.logIn;
    }
  }, {
    key: "render",
    value: function render() {
      return LoginComponent;
    }
  }]);
}(_screen.default);
