"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.hasOnlyClassicConnections = hasOnlyClassicConnections;
exports.isSSOEnabled = isSSOEnabled;
exports.matchesEnterpriseConnection = matchesEnterpriseConnection;
exports.usernameStyle = usernameStyle;
var _index = _interopRequireDefault(require("../index"));
var _login = _interopRequireDefault(require("./classic/login"));
var _sign_up_screen = _interopRequireDefault(require("./classic/sign_up_screen"));
var _mfa_login_screen = _interopRequireDefault(require("./classic/mfa_login_screen"));
var _reset_password = _interopRequireDefault(require("../connection/database/reset_password"));
var _index2 = _interopRequireWildcard(require("../core/sso/index"));
var sso = _index2;
var _index3 = require("../connection/database/index");
var _enterprise = require("../connection/enterprise");
var _tenant = require("../core/tenant");
var _email = require("../field/email");
var _username = require("../field/username");
var l = _interopRequireWildcard(require("../core/index"));
var _kerberos_screen = _interopRequireDefault(require("../connection/enterprise/kerberos_screen"));
var _hrd_screen = _interopRequireDefault(require("../connection/enterprise/hrd_screen"));
var _quick_auth_screen = _interopRequireDefault(require("../connection/enterprise/quick_auth_screen"));
var _quick_auth = require("../quick_auth");
var _loading_screen = _interopRequireDefault(require("../core/loading_screen"));
var _error_screen = _interopRequireDefault(require("../core/error_screen"));
var _last_login_screen = _interopRequireDefault(require("../core/sso/last_login_screen"));
var _sync = require("../sync");
var _index5 = require("../field/index");
var _index6 = require("../store/index");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function isSSOEnabled(m, options) {
  return matchesEnterpriseConnection(m, (0, _index3.databaseUsernameValue)(m, options));
}
function matchesEnterpriseConnection(m, usernameValue) {
  return (0, _enterprise.isEnterpriseDomain)(m, usernameValue);
}
function usernameStyle(m) {
  return (0, _index3.authWithUsername)(m) && !(0, _enterprise.isADEnabled)(m) ? 'username' : 'email';
}
function hasOnlyClassicConnections(m) {
  var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : undefined;
  for (var _len = arguments.length, strategies = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    strategies[_key - 2] = arguments[_key];
  }
  return l.hasOnlyConnections.apply(l, [m, type].concat(strategies)) && !l.hasSomeConnections(m, 'passwordless');
}
function validateAllowedConnections(m) {
  var anyDBConnection = l.hasSomeConnections(m, 'database');
  var anySocialConnection = l.hasSomeConnections(m, 'social');
  var anyEnterpriseConnection = l.hasSomeConnections(m, 'enterprise');
  if (!anyDBConnection && !anySocialConnection && !anyEnterpriseConnection) {
    var error = new Error('At least one database, enterprise or social connection needs to be available.');
    error.code = 'no_connection';
    m = l.stop(m, error);
  } else if (!anyDBConnection && (0, _index3.hasInitialScreen)(m, 'forgotPassword')) {
    var _error = new Error('The `initialScreen` option was set to "forgotPassword" but no database connection is available.');
    _error.code = 'unavailable_initial_screen';
    m = l.stop(m, _error);
  } else if (!anyDBConnection && !anySocialConnection && (0, _index3.hasInitialScreen)(m, 'signUp')) {
    var _error2 = new Error('The `initialScreen` option was set to "signUp" but no database or social connection is available.');
    _error2.code = 'unavailable_initial_screen';
    m = l.stop(m, _error2);
  }
  if ((0, _tenant.defaultDirectoryName)(m) && !(0, _tenant.defaultDirectory)(m)) {
    l.error(m, "The account's default directory \"".concat((0, _tenant.defaultDirectoryName)(m), "\" is not enabled."));
  }
  if ((0, _index3.defaultDatabaseConnectionName)(m) && !(0, _index3.defaultDatabaseConnection)(m)) {
    l.warn(m, "The provided default database connection \"".concat((0, _index3.defaultDatabaseConnectionName)(m), "\" is not enabled."));
  }
  if ((0, _enterprise.defaultEnterpriseConnectionName)(m) && !(0, _enterprise.defaultEnterpriseConnection)(m)) {
    l.warn(m, "The provided default enterprise connection \"".concat((0, _enterprise.defaultEnterpriseConnectionName)(m), "\" is not enabled or does not allow email/password authentication."));
  }
  return m;
}
var setPrefill = function setPrefill(m) {
  var _l$prefill$toJS = l.prefill(m).toJS(),
    email = _l$prefill$toJS.email,
    username = _l$prefill$toJS.username;
  if (typeof email === 'string') m = (0, _email.setEmail)(m, email);
  if (typeof username === 'string') m = (0, _username.setUsername)(m, username, 'username', false);
  return m;
};
function createErrorScreen(m, stopError) {
  setTimeout(function () {
    (0, _index6.swap)(_index6.updateEntity, 'lock', l.id(m), l.stop, stopError);
  }, 0);
  return new _error_screen.default();
}
var Classic = /*#__PURE__*/function () {
  function Classic() {
    _classCallCheck(this, Classic);
  }
  return _createClass(Classic, [{
    key: "didInitialize",
    value: function didInitialize(model, options) {
      model = (0, _index3.initDatabase)(model, options);
      model = (0, _enterprise.initEnterprise)(model, options);
      return model;
    }
  }, {
    key: "didReceiveClientSettings",
    value: function didReceiveClientSettings(m) {
      m = validateAllowedConnections(m);
      m = setPrefill(m);
      return m;
    }
  }, {
    key: "willShow",
    value: function willShow(m, opts) {
      m = (0, _index3.overrideDatabaseOptions)(m, opts);
      m = (0, _index3.resolveAdditionalSignUpFields)(m);
      if ((0, _sync.isSuccess)(m, 'client')) {
        m = validateAllowedConnections(m);
      }
      return m;
    }
  }, {
    key: "render",
    value: function render(m) {
      //if there's an error, we should show the error screen no matter what.
      if (l.hasStopped(m)) {
        return new _error_screen.default();
      }

      // TODO: remove the detail about the loading pane being pinned,
      // sticky screens should be handled at the box module.
      if (!(0, _sync.isDone)(m) || m.get('isLoadingPanePinned')) {
        return new _loading_screen.default();
      }
      if ((0, _index3.hasScreen)(m, 'login')) {
        if (!(0, _quick_auth.hasSkippedQuickAuth)(m) && (0, _index3.hasInitialScreen)(m, 'login')) {
          if ((0, _enterprise.isInCorpNetwork)(m)) {
            return new _kerberos_screen.default();
          }
          if (l.ui.rememberLastLogin(m)) {
            var lastUsedConnection = sso.lastUsedConnection(m);
            var lastUsedUsername = sso.lastUsedUsername(m);
            if (lastUsedConnection && (0, _sync.isSuccess)(m, 'sso') && l.hasConnection(m, lastUsedConnection.get('name')) && l.findConnection(m, lastUsedConnection.get('name')).get('type') !== 'passwordless') {
              return new _last_login_screen.default();
            }
          }
        }
        if ((0, _enterprise.quickAuthConnection)(m)) {
          return new _quick_auth_screen.default();
        }
        if ((0, _enterprise.isHRDActive)(m)) {
          return new _hrd_screen.default();
        }
      }
      if (!(0, _index3.hasScreen)(m, 'login') && !(0, _index3.hasScreen)(m, 'signUp') && !(0, _index3.hasScreen)(m, 'forgotPassword')) {
        var errorMessage = 'No available Screen. You have to allow at least one of those screens: `login`, `signUp`or `forgotPassword`.';
        var noAvailableScreenError = new Error(errorMessage);
        noAvailableScreenError.code = 'internal_error';
        noAvailableScreenError.description = errorMessage;
        return createErrorScreen(m, noAvailableScreenError);
      }
      var Screen = Classic.SCREENS[(0, _index3.getScreen)(m)];
      if (Screen) {
        return new Screen();
      }
      var noScreenError = new Error('Internal error');
      noScreenError.code = 'internal_error';
      noScreenError.description = "Couldn't find a screen \"".concat((0, _index3.getScreen)(m), "\"");
      return createErrorScreen(m, noScreenError);
    }
  }]);
}();
_defineProperty(Classic, "SCREENS", {
  login: _login.default,
  forgotPassword: _reset_password.default,
  signUp: _sign_up_screen.default,
  mfaLogin: _mfa_login_screen.default
});
var _default = exports.default = new Classic();
