"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _p2_api = _interopRequireDefault(require("./web_api/p2_api"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var Auth0WebAPI = /*#__PURE__*/function () {
  function Auth0WebAPI() {
    _classCallCheck(this, Auth0WebAPI);
    this.clients = {};
  }
  return _createClass(Auth0WebAPI, [{
    key: "setupClient",
    value: function setupClient(lockID, clientID, domain, opts) {
      var hostedLoginPage = window.location.host === domain;
      // when it is used on on the hosted login page, it shouldn't use popup mode
      opts.redirect = hostedLoginPage ? true : opts.redirect;

      // for cordova and electron we should force popup without SSO so it uses
      // /ro or /oauth/token for DB connections
      if (!hostedLoginPage && window && (!!window.cordova || !!window.electron)) {
        opts.redirect = false;
        opts.sso = false;
      }
      this.clients[lockID] = new _p2_api.default(lockID, clientID, domain, opts);
    }
  }, {
    key: "logIn",
    value: function logIn(lockID, options, authParams, cb) {
      this.clients[lockID].logIn(options, authParams, cb);
    }
  }, {
    key: "logout",
    value: function logout(lockID, query) {
      this.clients[lockID].logout(query);
    }
  }, {
    key: "signUp",
    value: function signUp(lockID, options, cb) {
      this.clients[lockID].signUp(options, cb);
    }
  }, {
    key: "resetPassword",
    value: function resetPassword(lockID, options, cb) {
      this.clients[lockID].resetPassword(options, cb);
    }
  }, {
    key: "startPasswordless",
    value: function startPasswordless(lockID, options, cb) {
      this.clients[lockID].passwordlessStart(options, cb);
    }
  }, {
    key: "passwordlessVerify",
    value: function passwordlessVerify(lockID, options, cb) {
      this.clients[lockID].passwordlessVerify(options, cb);
    }
  }, {
    key: "parseHash",
    value: function parseHash(lockID) {
      var hash = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      var cb = arguments.length > 2 ? arguments[2] : undefined;
      return this.clients[lockID].parseHash(hash, cb);
    }
  }, {
    key: "getUserInfo",
    value: function getUserInfo(lockID, token, callback) {
      return this.clients[lockID].getUserInfo(token, callback);
    }
  }, {
    key: "getProfile",
    value: function getProfile(lockID, token, callback) {
      return this.clients[lockID].getProfile(token, callback);
    }
  }, {
    key: "getChallenge",
    value: function getChallenge(lockID, callback) {
      return this.clients[lockID].getChallenge(callback);
    }
  }, {
    key: "getPasswordlessChallenge",
    value: function getPasswordlessChallenge(lockID, callback) {
      return this.clients[lockID].getPasswordlessChallenge(callback);
    }
  }, {
    key: "getPasswordResetChallenge",
    value: function getPasswordResetChallenge(lockID, callback) {
      return this.clients[lockID].getPasswordResetChallenge(callback);
    }
  }, {
    key: "getSSOData",
    value: function getSSOData(lockID) {
      var _this$clients$lockID;
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      return (_this$clients$lockID = this.clients[lockID]).getSSOData.apply(_this$clients$lockID, args);
    }
  }, {
    key: "getUserCountry",
    value: function getUserCountry(lockID, cb) {
      return this.clients[lockID].getUserCountry(function (err, data) {
        return cb(err, data && data.countryCode);
      });
    }
  }, {
    key: "checkSession",
    value: function checkSession(lockID, options, cb) {
      return this.clients[lockID].checkSession(options, cb);
    }
  }]);
}();
var _default = exports.default = new Auth0WebAPI();
