"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.renderEmailSentConfirmation = renderEmailSentConfirmation;
var _react = _interopRequireDefault(require("react"));
var _success_pane = _interopRequireDefault(require("../../ui/box/success_pane"));
var _actions = require("../../core/actions");
var l = _interopRequireWildcard(require("../../core/index"));
var c = _interopRequireWildcard(require("../../field/index"));
var _actions2 = require("./actions");
var m = _interopRequireWildcard(require("./index"));
var i18n = _interopRequireWildcard(require("../../i18n"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
// TODO: can't we get this from pops?

var RetrySvgIcon = /*#__PURE__*/_react.default.createElement("svg", {
  focusable: "false",
  height: "32px",
  style: {
    enableBackground: 'new 0 0 32 32'
  },
  version: "1.1",
  viewBox: "0 0 32 32",
  width: "32px",
  xmlSpace: "preserve",
  xmlns: "http://www.w3.org/2000/svg",
  xmlnsXlink: "http://www.w3.org/1999/xlink"
}, ' ', /*#__PURE__*/_react.default.createElement("path", {
  d: "M27.877,19.662c0.385-1.23,0.607-2.531,0.607-3.884c0-7.222-5.83-13.101-13.029-13.194v4.238    c4.863,0.093,8.793,4.071,8.793,8.956c0,0.678-0.088,1.332-0.232,1.966l-3.963-1.966l2.76,8.199l8.197-2.762L27.877,19.662z"
}), /*#__PURE__*/_react.default.createElement("path", {
  d: "M7.752,16.222c0-0.678,0.088-1.332,0.232-1.967l3.963,1.967l-2.76-8.199L0.99,10.785l3.133,1.553    c-0.384,1.23-0.607,2.531-0.607,3.885c0,7.223,5.83,13.1,13.03,13.194v-4.238C11.682,25.086,7.752,21.107,7.752,16.222z"
}));
var ResendLink = /*#__PURE__*/function (_React$Component) {
  function ResendLink() {
    _classCallCheck(this, ResendLink);
    return _callSuper(this, ResendLink, arguments);
  }
  _inherits(ResendLink, _React$Component);
  return _createClass(ResendLink, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        label = _this$props.label,
        onClick = _this$props.onClick;
      return /*#__PURE__*/_react.default.createElement("a", {
        className: "auth0-lock-resend-link",
        href: "#",
        onClick: onClick
      }, label, " ", /*#__PURE__*/_react.default.createElement("span", null, RetrySvgIcon));
    }
  }]);
}(_react.default.Component);
var Resend = /*#__PURE__*/function (_React$Component2) {
  function Resend() {
    var _this;
    _classCallCheck(this, Resend);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, Resend, [].concat(args));
    _defineProperty(_this, "handleClick", function (e) {
      e.preventDefault();
      (0, _actions2.resendEmail)(l.id(_this.props.lock));
    });
    return _this;
  }
  _inherits(Resend, _React$Component2);
  return _createClass(Resend, [{
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        labels = _this$props2.labels,
        lock = _this$props2.lock;
      var resendLink = m.resendAvailable(lock) && /*#__PURE__*/_react.default.createElement(ResendLink, {
        onClick: this.handleClick,
        label: m.resendFailed(lock) ? labels.retry : labels.resend
      });
      var resendingLabel = m.resendOngoing(lock) && /*#__PURE__*/_react.default.createElement("a", {
        className: "auth0-lock-resend-link"
      }, labels.resending);
      var resendSuccessLabel = m.resendSuccess(lock) && /*#__PURE__*/_react.default.createElement("span", {
        className: "auth0-lock-sent-label"
      }, labels.sent);
      var resendFailedLabel = m.resendFailed(lock) && /*#__PURE__*/_react.default.createElement("span", {
        className: "auth0-lock-sent-failed-label"
      }, labels.failed);
      return /*#__PURE__*/_react.default.createElement("span", null, resendLink, resendingLabel, resendSuccessLabel, resendFailedLabel);
    }
  }]);
}(_react.default.Component);
var EmailSentConfirmation = exports.default = /*#__PURE__*/function (_React$Component3) {
  function EmailSentConfirmation() {
    _classCallCheck(this, EmailSentConfirmation);
    return _callSuper(this, EmailSentConfirmation, arguments);
  }
  _inherits(EmailSentConfirmation, _React$Component3);
  return _createClass(EmailSentConfirmation, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var lock = this.props.lock;
      var closeHandler = l.ui.closable(lock) ? this.handleClose.bind(this) : undefined;
      var labels = {
        failed: i18n.str(lock, 'failedLabel'),
        resend: i18n.str(lock, 'resendLabel'),
        resending: i18n.str(lock, 'resendingLabel'),
        retry: i18n.str(lock, 'retryLabel'),
        sent: i18n.str(lock, 'sentLabel')
      };
      return /*#__PURE__*/_react.default.createElement(_success_pane.default, {
        lock: lock,
        backHandler: function backHandler() {
          return _this2.handleBack();
        },
        closeHandler: closeHandler
      }, /*#__PURE__*/_react.default.createElement("p", null, i18n.html(lock, ['success', 'magicLink'], c.email(lock))), /*#__PURE__*/_react.default.createElement(Resend, {
        labels: labels,
        lock: lock
      }));
    }
  }, {
    key: "handleBack",
    value: function handleBack() {
      (0, _actions2.restart)(l.id(this.props.lock));
    }
  }, {
    key: "handleClose",
    value: function handleClose() {
      (0, _actions.closeLock)(l.id(this.props.lock));
    }
  }]);
}(_react.default.Component);
function renderEmailSentConfirmation(lock) {
  var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  props.key = 'auxiliarypane';
  props.lock = lock;
  return m.passwordlessStarted(lock) ? /*#__PURE__*/_react.default.createElement(EmailSentConfirmation, props) : null;
}
