"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _screen = _interopRequireDefault(require("../../core/screen"));
var _quick_auth_pane = _interopRequireDefault(require("../../ui/pane/quick_auth_pane"));
var _actions = require("../../quick-auth/actions");
var _signed_in_confirmation = require("../../core/signed_in_confirmation");
var l = _interopRequireWildcard(require("../../core/index"));
var _enterprise = require("../enterprise");
var _index2 = require("../../connection/social/index");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
// TODO: handle this from CSS
function icon(strategy) {
  if (strategy === 'google-apps' || strategy === 'okta') return strategy;
  if (~['adfs', 'office365', 'waad'].indexOf(strategy)) return 'windows';
  return 'auth0';
}
var Component = function Component(_ref) {
  var i18n = _ref.i18n,
    model = _ref.model;
  var headerText = i18n.html('enterpriseLoginIntructions') || null;
  var header = headerText && /*#__PURE__*/_react.default.createElement("p", null, headerText);
  var theme = (0, _index2.authButtonsTheme)(model);
  var connection = (0, _enterprise.quickAuthConnection)(model);
  var connectionName = connection.getIn(['name']);
  var connectionDomain = connection.getIn(['domains', 0]);
  var connectionDisplayName = connection.getIn(['displayName']) || null;
  var preferConnectionDisplayName = l.ui.preferConnectionDisplayName(model);
  var buttonTheme = theme.get(connection.get('name'));
  var buttonLabel = buttonTheme && buttonTheme.get('displayName') || preferConnectionDisplayName && connectionDisplayName && i18n.str('loginAtLabel', connectionDisplayName) || connectionDomain && i18n.str('loginAtLabel', connectionDomain) || i18n.str('loginAtLabel', connectionName);
  var primaryColor = buttonTheme && buttonTheme.get('primaryColor');
  var foregroundColor = buttonTheme && buttonTheme.get('foregroundColor');
  var buttonIcon = buttonTheme && buttonTheme.get('icon');
  return /*#__PURE__*/_react.default.createElement(_quick_auth_pane.default, {
    buttonLabel: buttonLabel,
    buttonClickHandler: function buttonClickHandler(e) {
      return (0, _actions.logIn)(l.id(model), (0, _enterprise.quickAuthConnection)(model));
    },
    header: header,
    buttonIcon: buttonIcon,
    primaryColor: primaryColor,
    foregroundColor: foregroundColor,
    strategy: icon((0, _enterprise.quickAuthConnection)(model).get('strategy'))
  });
};
var QuickAuthScreen = exports.default = /*#__PURE__*/function (_Screen) {
  function QuickAuthScreen() {
    _classCallCheck(this, QuickAuthScreen);
    return _callSuper(this, QuickAuthScreen, ['enterpriseQuickAuth']);
  }
  _inherits(QuickAuthScreen, _Screen);
  return _createClass(QuickAuthScreen, [{
    key: "renderAuxiliaryPane",
    value: function renderAuxiliaryPane(lock) {
      return (0, _signed_in_confirmation.renderSignedInConfirmation)(lock);
    }
  }, {
    key: "render",
    value: function render() {
      return Component;
    }
  }]);
}(_screen.default);
