"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cancelMFALogin = cancelMFALogin;
exports.cancelResetPassword = cancelResetPassword;
exports.logIn = logIn;
exports.resetPassword = resetPassword;
exports.resetPasswordSuccess = resetPasswordSuccess;
exports.showLoginActivity = showLoginActivity;
exports.showLoginMFAActivity = showLoginMFAActivity;
exports.showResetPasswordActivity = showResetPasswordActivity;
exports.showSignUpActivity = showSignUpActivity;
exports.signUp = signUp;
exports.signUpError = signUpError;
exports.toggleTermsAcceptance = toggleTermsAcceptance;
var _index = require("../../store/index");
var _web_api = _interopRequireDefault(require("../../core/web_api"));
var _actions = require("../../core/actions");
var l = _interopRequireWildcard(require("../../core/index"));
var c = _interopRequireWildcard(require("../../field/index"));
var _dompurify = require("dompurify");
var _index4 = require("./index");
var i18n = _interopRequireWildcard(require("../../i18n"));
var _captcha = require("../captcha");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function logIn(id) {
  var needsMFA = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var m = (0, _index.read)(_index.getEntity, 'lock', id);
  var usernameField = (0, _index4.databaseLogInWithEmail)(m) ? 'email' : 'username';
  var username = c.getFieldValue(m, usernameField);
  var params = {
    connection: (0, _index4.databaseConnectionName)(m),
    username: username,
    password: c.getFieldValue(m, 'password')
  };
  var fields = [usernameField, 'password'];
  var isCaptchaValid = (0, _captcha.setCaptchaParams)(m, params, _captcha.Flow.DEFAULT, fields);
  if (!isCaptchaValid) {
    return (0, _captcha.showMissingCaptcha)(m, id);
  }
  var mfaCode = c.getFieldValue(m, 'mfa_code');
  if (needsMFA) {
    params['mfa_code'] = mfaCode;
    fields.push('mfa_code');
  }
  (0, _actions.logIn)(id, fields, params, function (id, error, fields, next) {
    if (error.error === 'a0.mfa_required') {
      return showLoginMFAActivity(id);
    }
    if (error) {
      var wasInvalid = error && error.code === 'invalid_captcha';
      return (0, _captcha.swapCaptcha)(id, _captcha.Flow.DEFAULT, wasInvalid, next);
    }
    next();
  });
}
function generateRandomUsername(length) {
  var result = '';
  var characters = 'abcdefghijklmnopqrstuvwxyz0123456789';
  var charactersLength = characters.length;
  for (var i = 0; i < length; i++) {
    result += characters.charAt(Math.floor(Math.random() * charactersLength));
  }
  return result;
}
function signUp(id) {
  var m = (0, _index.read)(_index.getEntity, 'lock', id);
  var fields = ['email', 'password'];

  // Skip the username validation if signUpHideUsernameField option is enabled.
  // We will generate a random username to avoid name collusion before we make the signup API call.
  if ((0, _index4.databaseConnectionRequiresUsername)(m) && !(0, _index4.signUpHideUsernameField)(m)) fields.push('username');
  (0, _index4.additionalSignUpFields)(m).forEach(function (x) {
    return fields.push(x.get('name'));
  });
  (0, _actions.validateAndSubmit)(id, fields, function (m) {
    var params = {
      connection: (0, _index4.databaseConnectionName)(m),
      email: c.getFieldValue(m, 'email'),
      password: c.getFieldValue(m, 'password'),
      autoLogin: (0, _index4.shouldAutoLogin)(m)
    };
    var isCaptchaValid = (0, _captcha.setCaptchaParams)(m, params, _captcha.Flow.DEFAULT, fields);
    if (!isCaptchaValid) {
      return (0, _captcha.showMissingCaptcha)(m, id);
    }
    if ((0, _index4.databaseConnectionRequiresUsername)(m)) {
      if ((0, _index4.signUpHideUsernameField)(m)) {
        var usernameValidation = (0, _index4.databaseConnection)(m).getIn(['validation', 'username']);
        var range = usernameValidation ? usernameValidation.toJS() : {
          max: 15
        };
        params.username = generateRandomUsername(range.max);
      } else {
        params.username = c.getFieldValue(m, 'username');
      }
    }
    if (!(0, _index4.additionalSignUpFields)(m).isEmpty()) {
      params.user_metadata = {};
      (0, _index4.additionalSignUpFields)(m).forEach(function (x) {
        var storage = x.get('storage');
        var fieldName = x.get('name');
        var fieldValue = (0, _dompurify.sanitize)(c.getFieldValue(m, x.get('name')), {
          ALLOWED_TAGS: []
        });
        switch (storage) {
          case 'root':
            params[fieldName] = fieldValue;
            break;
          default:
            if (!params.user_metadata) {
              params.user_metadata = {};
            }
            params.user_metadata[fieldName] = fieldValue;
            break;
        }
      });
    }
    var errorHandler = function errorHandler(error, popupHandler) {
      if (!!popupHandler) {
        popupHandler._current_popup.kill();
      }
      var wasInvalidCaptcha = error && error.code === 'invalid_captcha';
      (0, _captcha.swapCaptcha)(id, _captcha.Flow.DEFAULT, wasInvalidCaptcha, function () {
        setTimeout(function () {
          return signUpError(id, error);
        }, 250);
      });
    };
    try {
      // For now, always pass 'null' for the context as we don't need it yet.
      // If we need it later, it'll save a breaking change in hooks already in use.
      var context = null;
      l.runHook(m, 'signingUp', context, function () {
        _web_api.default.signUp(id, params, function (error, result, popupHandler) {
          if (error) {
            errorHandler(error, popupHandler);
          } else {
            for (var _len = arguments.length, args = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
              args[_key - 3] = arguments[_key];
            }
            signUpSuccess.apply(void 0, [id, result, popupHandler].concat(args));
          }
        });
      });
    } catch (e) {
      errorHandler(e);
    }
  });
}
function signUpSuccess(id, result, popupHandler) {
  var lock = (0, _index.read)(_index.getEntity, 'lock', id);
  l.emitEvent(lock, 'signup success', result);
  if ((0, _index4.shouldAutoLogin)(lock)) {
    (0, _index.swap)(_index.updateEntity, 'lock', id, function (m) {
      return m.set('signedUp', true);
    });

    // TODO: check options, redirect is missing
    var options = {
      connection: (0, _index4.databaseConnectionName)(lock),
      username: c.email(lock),
      password: c.password(lock)
    };
    if (!!popupHandler) {
      options.popupHandler = popupHandler;
    }
    return _web_api.default.logIn(id, options, l.auth.params(lock).toJS(), function (error) {
      if (error) {
        setTimeout(function () {
          return autoLogInError(id, error);
        }, 250);
      } else {
        for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          args[_key2 - 1] = arguments[_key2];
        }
        _actions.logInSuccess.apply(void 0, [id].concat(args));
      }
    });
  }
  var autoclose = l.ui.autoclose(lock);
  if (!autoclose) {
    (0, _index.swap)(_index.updateEntity, 'lock', id, function (lock) {
      return l.setSubmitting(lock, false).set('signedUp', true);
    });
  } else {
    (0, _actions.closeLock)(id, false);
  }
}
function signUpError(id, error) {
  var m = (0, _index.read)(_index.getEntity, 'lock', id);
  var invalidPasswordKeys = {
    PasswordDictionaryError: 'password_dictionary_error',
    PasswordNoUserInfoError: 'password_no_user_info_error',
    PasswordStrengthError: 'password_strength_error'
  };
  l.emitEvent(m, 'signup error', error);
  var errorKey = error.code === 'invalid_password' && invalidPasswordKeys[error.name] || error.code;
  var errorMessage = i18n.html(m, ['error', 'signUp', errorKey]) || i18n.html(m, ['error', 'signUp', 'lock.fallback']);
  if (error.code === 'hook_error') {
    (0, _index.swap)(_index.updateEntity, 'lock', id, l.setSubmitting, false, error.description || errorMessage);
    return;
  }
  if (errorKey === 'invalid_captcha') {
    errorMessage = i18n.html(m, ['error', 'login', errorKey]);
    return (0, _captcha.swapCaptcha)(id, _captcha.Flow.DEFAULT, true, function () {
      (0, _index.swap)(_index.updateEntity, 'lock', id, l.setSubmitting, false, errorMessage);
    });
  }
  (0, _index.swap)(_index.updateEntity, 'lock', id, l.setSubmitting, false, errorMessage);
}
function autoLogInError(id, error) {
  (0, _index.swap)(_index.updateEntity, 'lock', id, function (m) {
    var errorMessage = l.loginErrorMessage(m, error);
    if ((0, _index4.hasScreen)(m, 'login')) {
      return l.setSubmitting((0, _index4.setScreen)(m, 'login'), false, errorMessage);
    } else {
      return l.setSubmitting(m, false, errorMessage);
    }
  });
}
function resetPassword(id) {
  (0, _actions.validateAndSubmit)(id, ['email'], function (m) {
    var params = {
      connection: (0, _index4.databaseConnectionName)(m),
      email: c.getFieldValue(m, 'email')
    };
    var isCaptchaValid = (0, _captcha.setCaptchaParams)(m, params, _captcha.Flow.PASSWORD_RESET, ['email']);
    if (!isCaptchaValid) {
      return (0, _captcha.showMissingCaptcha)(m, id, _captcha.Flow.PASSWORD_RESET);
    }
    _web_api.default.resetPassword(id, params, function (error) {
      if (error) {
        setTimeout(function () {
          return resetPasswordError(id, error);
        }, 250);
      } else {
        resetPasswordSuccess(id);
      }
    });
  });
}
function resetPasswordSuccess(id) {
  var m = (0, _index.read)(_index.getEntity, 'lock', id);
  if ((0, _index4.hasScreen)(m, 'login')) {
    (0, _captcha.swapCaptcha)(id, _captcha.Flow.PASSWORD_RESET, false, function () {
      (0, _index.swap)(_index.updateEntity, 'lock', id, function (m) {
        return (0, _index4.setScreen)(l.setSubmitting(m, false), 'login', ['']);
      } // array with one empty string tells the function to not clear any field
      );
    });

    // TODO: should be handled by box
    setTimeout(function () {
      var successMessage = i18n.html(m, ['success', 'forgotPassword']);
      (0, _index.swap)(_index.updateEntity, 'lock', id, l.setGlobalSuccess, successMessage);
    }, 500);
  } else {
    if (l.ui.autoclose(m)) {
      (0, _actions.closeLock)(id);
    } else {
      (0, _captcha.swapCaptcha)(id, _captcha.Flow.PASSWORD_RESET, false, function () {
        (0, _index.swap)(_index.updateEntity, 'lock', id, function (m) {
          return l.setSubmitting(m, false).set('passwordResetted', true);
        });
      });
    }
  }
}
function resetPasswordError(id, error) {
  var m = (0, _index.read)(_index.getEntity, 'lock', id);
  var key = error.code;
  if (error.code === 'invalid_captcha') {
    var captchaConfig = l.passwordResetCaptcha(m);
    key = captchaConfig.get('provider') === 'recaptcha_v2' || captchaConfig.get('provider') === 'recaptcha_enterprise' ? 'invalid_recaptcha' : 'invalid_captcha';
  }
  var errorMessage = i18n.html(m, ['error', 'forgotPassword', key]) || i18n.html(m, ['error', 'forgotPassword', 'lock.fallback']);
  (0, _captcha.swapCaptcha)(id, _captcha.Flow.PASSWORD_RESET, error.code === 'invalid_captcha', function () {
    (0, _index.swap)(_index.updateEntity, 'lock', id, l.setSubmitting, false, errorMessage);
  });
}
function showLoginActivity(id) {
  var fields = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ['password'];
  var m = (0, _index.read)(_index.getEntity, 'lock', id);
  var captchaConfig = l.captcha(m);
  if (captchaConfig && captchaConfig.get('provider') === 'arkose') {
    (0, _index.swap)(_index.updateEntity, 'lock', id, _index4.setScreen, 'login', fields);
  } else {
    (0, _captcha.swapCaptcha)(id, 'login', false, function () {
      (0, _index.swap)(_index.updateEntity, 'lock', id, _index4.setScreen, 'login', fields);
    });
  }
}
function showSignUpActivity(id) {
  var fields = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ['password'];
  var m = (0, _index.read)(_index.getEntity, 'lock', id);
  var captchaConfig = l.captcha(m);
  if (captchaConfig && captchaConfig.get('provider') === 'arkose') {
    (0, _index.swap)(_index.updateEntity, 'lock', id, _index4.setScreen, 'signUp', fields);
  } else {
    (0, _captcha.swapCaptcha)(id, 'login', false, function () {
      (0, _index.swap)(_index.updateEntity, 'lock', id, _index4.setScreen, 'signUp', fields);
    });
  }
}
function showResetPasswordActivity(id) {
  var fields = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ['password'];
  var m = (0, _index.read)(_index.getEntity, 'lock', id);
  var captchaConfig = l.passwordResetCaptcha(m);
  if (captchaConfig && captchaConfig.get('provider') === 'arkose') {
    (0, _index.swap)(_index.updateEntity, 'lock', id, _index4.setScreen, 'forgotPassword', fields);
  } else {
    (0, _captcha.swapCaptcha)(id, 'login', false, function () {
      (0, _index.swap)(_index.updateEntity, 'lock', id, _index4.setScreen, 'forgotPassword', fields);
    });
  }
}
function cancelResetPassword(id) {
  return showLoginActivity(id);
}
function cancelMFALogin(id) {
  return showLoginActivity(id);
}
function toggleTermsAcceptance(id) {
  (0, _index.swap)(_index.updateEntity, 'lock', id, _index4.toggleTermsAcceptance);
}
function showLoginMFAActivity(id) {
  var fields = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ['mfa_code'];
  (0, _index.swap)(_index.updateEntity, 'lock', id, _index4.setScreen, 'mfaLogin', fields);
}
